package com.ejianc.foundation.share.mapper;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.vo.MaterialVO;

@Mapper
public interface MaterialMapper {

	int updateCategoryCodeByCategoryId(@Param("tenantId") Long tenantId, @Param("categoryId") Long categoryId,
									   @Param("categoryCode") String categoryCode, @Param("financialId") Long financialId, @Param("financialName") String financialName);

	int updateByCategoryId(@Param("tenantId") Long tenantId, @Param("categoryId") Long categoryId,
						   @Param("subjectId") Long subjectId, @Param("subjectName") String subjectName, @Param("financialId") Long financialId, @Param("financialName") String financialName);

	List<MaterialEntity> queryListByCategoryId(@Param("tenantId") Long tenantId, @Param("categoryId") Long categoryId);

	List<MaterialEntity> queryList(Map<String, Object> condition);

	Long queryCount(Map<String, Object> condition);

	MaterialEntity queryDetail(@Param("tenantId") Long tenantId, @Param("id") Long id);

	List<MaterialEntity> queryItem(@Param("tenantId") Long tenantId, @Param("ids") List<Long> ids);

	void save(MaterialVO materialVo);

	void insertBatch(@Param("tenantId") Long tenantId, @Param("list") List<MaterialVO> list);

	void update(MaterialVO uniqueBean);

	void amend(@Param("id") Long id, @Param("property") Long property, @Param("propertyName") String propertyName, @Param("tenantId") Long tenantId);

	void delete(@Param("tenantId") Long tenantId, @Param("id") Long id);

	MaterialVO queryExitFlag(@Param("tenantId") Long tenantId, @Param("name") String name, @Param("spec") String spec, @Param("unitName") String unitName, @Param("categoryId") Long categoryId);

	List<MaterialVO> queryExcelFlag(@Param("tenantId") Long tenantId, @Param("name") String name, @Param("spec") String spec, @Param("unitName") String unitName, @Param("categoryName") String categoryName);

	MaterialVO queryByCode(@Param("tenantId") Long tenantId, @Param("code") String code);

	List<MaterialEntity> queryExportList(Map<String, Object> condition);

	void insertMaterialListFromPlatform(@Param("tenantId") Long tenantId);

	List<MaterialEntity> queryRefMaterialList(Map<String, Object> params);

	Long queryRefMaterialCount(Map<String, Object> params);

	MaterialEntity queryBySourceId(@Param("sourceId") String sourceId, @Param("tenantId") Long tenantId);

	List<MaterialEntity> queryMaterialByIds(@Param("ids") List<Long> ids, @Param("tenantId") Long tenantId);


    List<MaterialEntity> queryZjwjRefMaterialList(Map<String, Object> params);

	Long queryZjwjRefMaterialCount(Map<String, Object> params);

    List<MaterialEntity> queryMaterialListByCodes(Map<String, Object> params);

	void updateFinancialByCategoryIds(@Param("financialId") Long financialId, @Param("financialName") String financialName,
									  @Param("categoryIds") List<Long> categoryIds, @Param("tenantId") Long tenantId);

	/**
	 * like or 模糊匹配
	 *
	 * @param tenantId     租户id
	 * @param name         清单名称
	 * @param names        清单名称分词
	 * @param type         费用类型
	 * @param categoryName 分类名称
	 * @param spec         规范型号
	 * @param unitName     单位名称
	 *
	 * @param code
	 * @return {@link List}<{@link MaterialPlusVO}>
	 */
	List<MaterialPlusVO> findFuzzyResultListByLikeOr(@Param(value = "tenantId") Long tenantId,
													 @Param(value = "name") String name,
													 @Param(value = "names") List<String> names,
													 @Param(value = "type") Integer type,
													 @Param(value = "categoryName") String categoryName,
													 @Param(value = "spec") String spec,
													 @Param(value = "unitName") String unitName, @Param(value = "code") String code);

	/**
	 * 模糊匹配分页查询
	 *
	 * @param page          分页参数
	 * @param tenantId      租户id
	 * @param name          清单名称
	 * @param names         清单名称分词
	 * @param type          费用类型
	 * @param categoryName  分类名称
	 * @param spec          规范型号
	 * @param unitName      单位名称
	 * @param fuzzyName     清单名称模糊
	 * @param fuzzySpec     规格型号模糊
	 * @param fuzzyUnitName 单位名称模糊
	 *
	 * @return {@link List}<{@link MaterialPlusVO}>
	 */
	List<MaterialPlusVO> fuzzyMatchQueryPage(Page<MaterialPlusVO> page,
											 @Param(value = "tenantId") Long tenantId,
											 @Param(value = "name") String name,
											 @Param(value = "names") List<String> names,
											 @Param(value = "type") Integer type,
											 @Param(value = "categoryName") String categoryName,
											 @Param(value = "spec") String spec,
											 @Param(value = "unitName") String unitName,
											 @Param(value = "fuzzyName") String fuzzyName,
											 @Param(value = "fuzzySpec") String fuzzySpec,
											 @Param(value = "fuzzyUnitName") String fuzzyUnitName);
}
