/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ProsubItemImportVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/prosubItem"})
public class ProsubItemController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PSI_CODE";
    @Autowired
    private IProsubItemService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProsubCategoryService prosubCategoryService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProsubItemVO> saveOrUpdate(@RequestBody ProsubItemVO saveorUpdateVO) {
        CommonResponse<ProsubItemVO> response = this.service.saveOrUpdateProsubItem(saveorUpdateVO);
        return response;
    }

    @RequestMapping(value={"/bandSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List ids = (List)map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String)map.get("subjectName");
        this.service.updateSubject(subjectId, subjectName, ids);
        return CommonResponse.success((String)"\u7ed1\u5b9a\u6210\u529f!");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProsubItemVO> queryDetail(Long id) {
        ProsubItemEntity entity = (ProsubItemEntity)((Object)this.service.selectById(id));
        ProsubItemVO vo = (ProsubItemVO)BeanMapper.map((Object)((Object)entity), ProsubItemVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProsubItemVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProsubItemVO>> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        Map paramMap = param.getParams();
        paramMap.put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (paramMap.get("categoryId") != null) {
            Object categoryId = ((Parameter)paramMap.get("categoryId")).getValue();
            if (categoryId != null) {
                ProsubCategoryEntity categoryEntity = (ProsubCategoryEntity)((Object)this.prosubCategoryService.selectById((Serializable)((Object)categoryId.toString())));
                if (categoryEntity != null) {
                    paramMap.put("innerCode", new Parameter("like_right", (Object)categoryEntity.getInnerCode()));
                    paramMap.remove("categoryId");
                }
            } else {
                param.getParams().remove("categoryId");
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ProsubItemVO> list = this.service.queryProsubItemList((Page<ProsubItemVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, ProsubItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ProsubCategoryEntity> categoryvos;
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        ArrayList allCategoryIds = null;
        if (null != param.getParams() && null != param.getParams().get("categoryIds") && CollectionUtils.isNotEmpty(categoryvos = this.prosubCategoryService.queryListByPids(JSONArray.parseArray((String)JSONObject.toJSONString((Object)((Parameter)param.getParams().get("categoryIds")).getValue()), Long.class)))) {
            allCategoryIds = new ArrayList();
            allCategoryIds.addAll(categoryvos.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        List<ProsubItemVO> list = this.service.queryAllByCategoryIds(allCategoryIds, InvocationInfoProxy.getTenantid(), 0);
        HashMap<String, List<ProsubItemVO>> beans = new HashMap<String, List<ProsubItemVO>>(list.size());
        beans.put("records", list);
        ExcelExport.getInstance().export("prosub-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProsubItemData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProsubItemVO>> refProsubItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProsubItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"prosub-import.xlsx", (String)"\u4e13\u4e1a\u5206\u5305\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelProsubImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = this.service.excelProsubImport(request);
        return response;
    }

    @RequestMapping(value={"/saveImportExcelProsubItem"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelProsubItem(@RequestBody List<ProsubItemImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = new ArrayList();
        importVos.forEach(importVO -> {
            ProsubItemEntity entity = (ProsubItemEntity)((Object)((Object)BeanMapper.map((Object)importVO, ProsubItemEntity.class)));
            entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
            entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            entity.setEnabled(0);
            list.add(entity);
        });
        this.service.saveBatch(list, list.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/changeState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ProsubItemVO saveorUpdateVO) {
        ProsubItemEntity entity = (ProsubItemEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProsubItemEntity.class));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
        updateWrapper.set(ProsubItemEntity::getEnabled, (Object)entity.getEnabled());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"refProSubItemPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProsubItemVO>> refProSubItemPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("categoryName", "trawlingCode", "trawlingName", "priceType", "unitName", "jobContent", "remarks"));
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            ProsubCategoryEntity prosubCategoryEntity = (ProsubCategoryEntity)((Object)this.prosubCategoryService.selectById(categoryId));
            if (prosubCategoryEntity != null) {
                String innerCode = prosubCategoryEntity.getInnerCode();
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("inner_code", new Parameter("like", (Object)innerCode));
                List prosubCategoryEntities = this.prosubCategoryService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty((Collection)prosubCategoryEntities)) {
                    List ids = prosubCategoryEntities.stream().filter(s -> s.getId() != null).map(BaseEntity::getId).collect(Collectors.toList());
                    param.getParams().put("category_id", new Parameter("in", ids));
                }
            } else {
                return CommonResponse.error((String)"\u5f53\u524d\u5206\u7c7b\u4e0d\u5b58\u5728\u6863\u6848\uff01");
            }
        }
        param.getParams().put("enabled", new Parameter("eq", (Object)0));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("trawlingCode", "asc");
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProsubItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"proSubItemPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProsubItemVO>> proSubItemPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String categoryId, @RequestParam(required=false) String enabled) {
        ProsubCategoryEntity prosubCategoryEntity;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setFuzzyFields(Arrays.asList("trawlingCode", "trawlingName", "priceType", "unitName", "jobContent", "remarks"));
        if (StringUtils.isNotBlank((CharSequence)categoryId) && (prosubCategoryEntity = (ProsubCategoryEntity)((Object)this.prosubCategoryService.selectById((Serializable)((Object)categoryId)))) != null) {
            String innerCode = prosubCategoryEntity.getInnerCode();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("inner_code", new Parameter("like", (Object)innerCode));
            List prosubCategoryEntities = this.prosubCategoryService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)prosubCategoryEntities)) {
                List ids = prosubCategoryEntities.stream().filter(s -> s.getId() != null).map(BaseEntity::getId).collect(Collectors.toList());
                param.getParams().put("category_id", new Parameter("in", ids));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)enabled)) {
            param.getParams().put("enabled", new Parameter("eq", (Object)enabled));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProsubItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

