package com.ejianc.foundation.init.service.impl;

import com.ejianc.foundation.init.mapper.InitMapper;
import com.ejianc.foundation.init.service.InitService;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

@Service
@Transactional
public class InitServiceImpl implements InitService {
    @Autowired
    InitMapper initMapper;
    @Autowired
    ISupplierCategoryService iSupplierCategoryService;
    @Autowired
    ISupplierService iSupplierService;
    @Autowired
    private ICustomerCategoryService iCustomerCategoryService;
    @Autowired
    private ICustomerService iCustomerService;


    @Override
    public void initData(EnterpriseInitVO vo) {
        if(isNotAdmin()){
            throw new BusinessException("无权操作!");
        }
        if(vo.getTenantId() == null){
            throw new BusinessException("租户id不存在!");
        }
        //建表
        initMapper.createThreeTables(vo.getTenantId());
        //创建客户
        CustomerCategoryEntity customerCategoryEntity = new CustomerCategoryEntity();
        customerCategoryEntity.setId(IdWorker.getId());
        customerCategoryEntity.setName("内部客户");
        customerCategoryEntity.setCode("CC-"+customerCategoryEntity.getId());
        customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
        customerCategoryEntity.setSequence(1);
        customerCategoryEntity.setDescription("系统创建！");
        customerCategoryEntity.setTenantId(vo.getTenantId());
        iCustomerCategoryService.saveOrUpdate(customerCategoryEntity,false);
        CustomerEntity customerEntity = new CustomerEntity();
        customerEntity.setId(IdWorker.getId());
        customerEntity.setSocialCreditCode(vo.getSocialCreditCode());
        customerEntity.setCode("CUS-"+customerEntity.getId());
        customerEntity.setName(vo.getName());
        customerEntity.setCategoryId(customerCategoryEntity.getId());
        customerEntity.setTenantId(vo.getTenantId());
        customerEntity.setLegal(vo.getLegalName());
        customerEntity.setTelephone(vo.getTelephone());
        customerEntity.setDescription("系统创建!");
        iCustomerService.saveOrUpdate(customerEntity,false);
        //创建供应商
        SupplierCategoryEntity supplierCategoryEntity = new SupplierCategoryEntity();
        supplierCategoryEntity.setId(IdWorker.getId());
        supplierCategoryEntity.setCode("SPC-"+supplierCategoryEntity.getId());
        supplierCategoryEntity.setTenantId(vo.getTenantId());
        supplierCategoryEntity.setDescription("系统创建!");
        supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
        supplierCategoryEntity.setName("内部供应商");
        supplierCategoryEntity.setSequence(1);
        iSupplierCategoryService.saveOrUpdate(supplierCategoryEntity,false);
        SupplierEntity supplierEntity = new SupplierEntity();
        supplierEntity.setId(IdWorker.getId());
        supplierEntity.setSocialCreditCode(vo.getSocialCreditCode());
        supplierEntity.setCategoryId(supplierCategoryEntity.getId());
        supplierEntity.setCode("SP-"+supplierEntity.getId());
        supplierEntity.setTenantId(vo.getTenantId());
        supplierEntity.setName(vo.getName());
        supplierEntity.setLegal(vo.getLegalName());
        supplierEntity.setTelephone(vo.getTelephone());
        supplierEntity.setDescription("系统创建!");
        supplierEntity.setEnabled(1);
        iSupplierService.saveOrUpdate(supplierEntity,false);
    }

    @Override
    public void rollBack(Long tenantId) {
        if(isNotAdmin()){
            throw new BusinessException("无权操作!");
        }
        if(tenantId == null){
            throw new BusinessException("租户id不存在!");
        }
        initMapper.dropThreeTables(tenantId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        List<SupplierCategoryEntity> s = iSupplierCategoryService.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(s)){
            iSupplierCategoryService.removeByIds(s.stream().map(SupplierCategoryEntity::getId).collect(Collectors.toList()));
        }
        List<SupplierEntity> supplierEntityList = iSupplierService.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(supplierEntityList)){
            iSupplierService.removeByIds(supplierEntityList.stream().map(SupplierEntity::getId).collect(Collectors.toList()));
        }
        List<CustomerCategoryEntity> customerCategoryEntities = iCustomerCategoryService.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(customerCategoryEntities)){
            iCustomerCategoryService.removeByIds(customerCategoryEntities.stream().map(CustomerCategoryEntity::getId).collect(Collectors.toList()));
        }
        List<CustomerEntity> customerEntities = iCustomerService.queryList(queryParam,false);
        if(ListUtil.isNotEmpty(customerEntities)){
            iCustomerService.removeByIds(customerEntities.stream().map(CustomerEntity::getId).collect(Collectors.toList()));
        }

    }

    public Boolean isNotAdmin(){
        return !InvocationInfoProxy.getTenantid().equals(999999L);
    }
}
