package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BPMTaskInfoVO;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.controller.param.RequestParams;
import com.ejianc.foundation.share.controller.resp.InformationPortletContent;
import com.ejianc.foundation.share.controller.resp.InformationPortletData;
import com.ejianc.foundation.share.service.IAdmixTureService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import java.io.StringWriter;
import java.util.*;


@Component
@WebService(
        serviceName = "PortalService",
        targetNamespace = "http://pm.cni-ht.com/")
public class PortalHandler {
    @Autowired
    private IBpmApi bpmApi;
    @Value("${common.env.base-host}")
    private String baseHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;
    public PortalHandler() {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
    }


    @WebMethod(operationName = "Todo")
    public String todo(
            @WebParam(name = "parameters") RequestParams wrapper) { // 接收字符串参数


        String userId2 = wrapper.getUserId();
        String userCode1 = wrapper.getUserCode();
        logger.info("userId2----"+userId2);
        logger.info("userCode1----"+userCode1);
        Long userId = 1247777316689256450L;
        getUserContext(userId);
        InvocationInfoProxy.getTenantid();

        InformationPortletData data = new InformationPortletData();
        //根据
        Map<String,Object> queryParam = new HashMap<>();
        queryParam.put("userId","1247777316689256450");
        queryParam.put("pageIndex",1);
        queryParam.put("pageSize",10);

        CommonResponse<List<BPMTaskInfoVO>> approveList = bpmApi.queryWaitList(queryParam);
        if (!approveList.isSuccess()){
            throw new BusinessException("查询待办信息失败!");
        }

        List<BPMTaskInfoVO> records = approveList.getData();
        // 构建示例数据（实际应根据参数查询）
        List<InformationPortletContent> items = new ArrayList<>();
        for(BPMTaskInfoVO bpmTaskInfoVO : records){
            InformationPortletContent item = new InformationPortletContent();
            item.setContentTitle(bpmTaskInfoVO.getProcInstTitle());
            try {
                XMLGregorianCalendar cal = DatatypeFactory.newInstance()
                        .newXMLGregorianCalendar(new GregorianCalendar());
                item.setDateTime(cal);
            } catch (Exception e) {
                e.printStackTrace();
            }
            items.add(item);
        }

//        items.add(createItem("数据显示标题", "点击跳转Url", paramMap));
//        items.add(createItem("", "", paramMap)); // 空数据项

        data.setItems(items.toArray(new InformationPortletContent[0]));
        data.setTotal(items.size());

        return convertToXml(data);
    }

    private void getUserContext(Long userId) {
        JSONObject userContext = getToken(userId);
        StringBuilder authtoken = new StringBuilder();
        authtoken.append("userType=").append(userContext.get("userType"))
                .append(";userCode=").append(userContext.get("userCode"))
                .append(";orgId=").append(userContext.get("orgId"))
                .append(";tenantid=").append(userContext.get("tenantid"))
                .append(";token=").append(userContext.get("token"))
                .append(";u_logints=").append(userContext.get("u_logints"))
                .append(";u_usercode=").append(userContext.get("u_usercode"))
                .append(";userId=").append(userContext.get("userId"));

        if(authtoken.length() > 0) {
            InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());
        }
        if(null != userContext) {
            InvocationInfoProxy.setTenantid(userContext.getLong("tenantid"));
            InvocationInfoProxy.setUserid(userContext.getLong("userId"));
            InvocationInfoProxy.setUsercode(userContext.getString("userCode"));
            InvocationInfoProxy.setOrgId(userContext.getLong("orgId"));

        }
    }

    //    private InformationPortletContent createItem(String title, String url,
//                                                 Map<String, String> params) {
//        InformationPortletContent item = new InformationPortletContent();
//        item.setContentTitle(title);
//        item.setContentUrl(url);
//        item.setEmpID(params.getOrDefault("userId", ""));
//
//        try {
//            XMLGregorianCalendar cal = DatatypeFactory.newInstance()
//                    .newXMLGregorianCalendar(new GregorianCalendar());
//            item.setDateTime(cal);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        return item;
//    }

    private JSONObject getToken(Long userId) {
    if(null != baseHost) {
        String initContextUrl = baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        if(null != InvocationInfoProxy.getUserid()) {
            initContextUrl = initContextUrl + "&userId="+userId;
        }
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);

        CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
        try {
            if(userContextResponse.isSuccess()) {
                return userContextResponse.getData().getJSONObject("userContext");
            }
        } catch (Exception e) {
            logger.error("初始化异步任务上下文异常：",e);
            return null;
        }
    }
    return null;
}
    private String convertToXml(InformationPortletData data) {
        try {
            JAXBContext context = JAXBContext.newInstance(InformationPortletData.class);
            Marshaller marshaller = context.createMarshaller();

            // 关键配置
            marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            marshaller.setProperty(Marshaller.JAXB_SCHEMA_LOCATION, " ");

            StringWriter sw = new StringWriter();
            marshaller.marshal(data, sw);

            return sw.toString();
        } catch (Exception e) {
            throw new RuntimeException("XML生成失败", e);
        }
    }

    private Map<String, String> parseParams(String paramStr) {
        Map<String, String> params = new HashMap<>();
        if (paramStr != null) {
            String[] pairs = paramStr.split("&");
            for (String pair : pairs) {
                String[] kv = pair.split("=");
                if (kv.length == 2) {
                    params.put(kv[0], kv[1]);
                }
            }
        }
        return params;
    }
}