package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/shareEquipmentApi/")
public class EquipmentApi {

    @Autowired
    private IEquipmentService equipmentService;
	@Autowired
	private IEquipmentCategoryService equipmentCategoryService;

    /**
     * 根据编码查询设备详情
     * @Author liyongjia
     * @param code
     * @return
     */
    @GetMapping("queryEquipmentByCode")
    public CommonResponse<EquipmentVO> queryMaterialByCode(@RequestParam(value = "code") String code) {
        EquipmentVO vo = equipmentService.queryByCode(String.valueOf(code));
        if(vo == null){
            return CommonResponse.error("查询失败,没有查询到该编码对应的设备！");
        }
    	return CommonResponse.success("查询成功！", vo);
    }

    /**
     * @Author xuannl
     * @Date 2022/04/18 根据ids查询物资
     * @Param [ids]
     * @Return
     */
    @GetMapping(value = "queryEquipmentItemByIds")
    CommonResponse<List<EquipmentVO>> queryEquipmentItemByIds(@RequestParam(value = "ids") List<Long> ids){
        List<EquipmentVO> equipmentVOS = equipmentService.queryItem(ids);
        if(null != equipmentVOS && equipmentVOS.size() > 0){
            return CommonResponse.success(equipmentVOS);
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }

    /**
     * 根据idList查详情
     *
     * @param idList
     * @return
     */
    @PostMapping("queryEquipmentItemByIdList")
    public CommonResponse<List<EquipmentVO>> queryEquipmentItemByIdList(@RequestBody List<Long> idList) {
        List<EquipmentVO> equipmentVOS = equipmentService.queryItem(idList);
        if(null != equipmentVOS && equipmentVOS.size() > 0){
            return CommonResponse.success(equipmentVOS);
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }

    /**
     * 根据ids查询分类
     *
     * @param ids
     * @return
     */
    @PostMapping("queryCategoryListByIds")
    public CommonResponse<List<EquipmentCategoryVO>> queryCategoryListByIds(@RequestBody List<Long> ids) {
        List<EquipmentCategoryVO> list = equipmentCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success("查询成功！", list);
    }

    /**
     * 根据编码集合查询档案列表
     * @Author zhangwx
     * @param codeList
     * @return
     */
    @PostMapping("queryEquipmentListByCodes")
    public CommonResponse<List<EquipmentVO>> queryEquipmentListByCodes(@RequestBody List<String> codeList) {
        List<EquipmentVO> list = equipmentService.queryEquipmentListByCodes(codeList);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.success("查询成功！", list);
        }
        return CommonResponse.error("查询失败,没有查询到该编码对应的档案！");
    }
}
