package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.*;
import com.ejianc.foundation.share.mapper.LabsubCategoryMapper;
import com.ejianc.foundation.share.mapper.ProsubItemMapper;
import com.ejianc.foundation.share.service.ILabsubCategoryService;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.LabsubItemImportVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.share.mapper.LabsubItemMapper;
import com.ejianc.foundation.share.service.ILabsubItemService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 劳务分包档案
 *
 * @author generator
 *
 */
@Service("labsubItemService")
public class LabsubItemServiceImpl extends BaseServiceImpl<LabsubItemMapper, LabsubItemEntity> implements ILabsubItemService{
    @Autowired
    private ILabsubItemService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private LabsubItemMapper labsubItemMapper;
    @Autowired
    private ProsubItemMapper prosubItemMapper;

    @Autowired
    private IProjectSetService projectSetService;

    @Autowired
    private ISubjectOrgService subjectOrgService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "LSI_CODE";

    // 档案来源数据是否查询父级分类 0：否 1：是
    private final String PLANT_CODE = "P-su39U70181";

    @Autowired
    private IParamConfigApi paramConfigApi;


    @Autowired
    private ILabsubCategoryService labsubCategoryService;

    @Override
    public CommonResponse updateByCategoryId(Long categoryId, String subjectIds, String subjectNames, String subjectRelations) {
        int i = labsubItemMapper.updateByCategoryId(categoryId, subjectIds, subjectNames, subjectRelations);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<LabsubItemImportVO> successList = new ArrayList<>();
        List<LabsubItemImportVO> errorList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("劳务分包档案超过10000条，请分批上传！");
                }
                Map<String, List<LabsubCategoryEntity>> caListMap = new HashMap<>();
                Map<String, ProsubItemVO> materialMap = new HashMap<>();
                Map<String, ProsubItemVO> materialBeanMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    LabsubItemImportVO prosubItemImport = new LabsubItemImportVO();
                    prosubItemImport.setId(IdWorker.getId());
                    prosubItemImport.setCategoryCode(datas.get(0));
                    prosubItemImport.setTrawlingCode(datas.get(1));
                    prosubItemImport.setTrawlingName(datas.get(2));
                    prosubItemImport.setPriceType(datas.get(3));
                    prosubItemImport.setUnitName(datas.get(4));
                    prosubItemImport.setJobContent(datas.get(5));
                    prosubItemImport.setDetailMeasurementRules(datas.get(6));
                    prosubItemImport.setRemarks(datas.get(7));
                    if (StringUtils.isBlank(datas.get(0))) {
                        prosubItemImport.setRemarks("所属分类编码为空！");
                        errorList.add(prosubItemImport);
                        continue;
                    }
                    if (StringUtils.isBlank(datas.get(1))) {
                        prosubItemImport.setRemarks("档案编码为空！");
                        errorList.add(prosubItemImport);
                        continue;
                    }
                    if (StringUtils.isBlank(datas.get(2))) {
                        prosubItemImport.setRemarks("档案名称为空！");
                        errorList.add(prosubItemImport);
                        continue;
                    }
//                    if (StringUtils.isBlank(datas.get(3))) {
//                        prosubItemImport.setRemarks("价格类型为空！");
//                        errorList.add(prosubItemImport);
//                        continue;
//                    }
                    //通过档案分类Code获取档案分类ID
                    List<LabsubCategoryEntity> materialCategoryVo = caListMap.get(datas.get(0));
                    if (ListUtil.isEmpty(materialCategoryVo)) {
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("categoryCode",new Parameter(QueryParam.EQ,String.valueOf(datas.get(0))));
                        materialCategoryVo = labsubCategoryService.queryList(queryParam,false);
                        if (ListUtil.isNotEmpty(materialCategoryVo)) {
                            caListMap.put(datas.get(0), materialCategoryVo);
                        }
                    }
                    if (ListUtil.isNotEmpty(materialCategoryVo)) {
                        prosubItemImport.setCategoryId(materialCategoryVo.get(0).getId());
                        prosubItemImport.setCategoryName(materialCategoryVo.get(0).getCategoryName());
                        if (StringUtils.isBlank(datas.get(1))) {//没有编号，自动生成一个
                            CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                            if(codeBatchByRuleCode.isSuccess()){
                                prosubItemImport.setTrawlingCode(codeBatchByRuleCode.getData());
                            }else{
                                prosubItemImport.setTrawlingCode(System.currentTimeMillis() + "");
                            }

                        } else {//有编号，判重
                            ProsubItemVO vo = materialMap.get(datas.get(1));
                            if (vo == null) {
                                QueryWrapper<LabsubItemEntity> queryWrapper = new QueryWrapper<>();
                                queryWrapper.eq("trawling_code",String.valueOf(datas.get(1)));
                                LabsubItemEntity one = null;
                                List<LabsubItemEntity> list = service.list(queryWrapper);
                                if (CollectionUtils.isNotEmpty(list)){
                                    one=list.get(0);
                                }
                                if(one != null){
                                    vo = BeanMapper.map(one, ProsubItemVO.class);
                                }
                                if (vo != null) {
                                    materialMap.put(datas.get(1), vo);
                                }
                            }
                            if (vo != null) {
                                prosubItemImport.setRemarks("档案编号重复！");
                                errorList.add(prosubItemImport);
                                continue;
                            }
                        }
                        ProsubItemVO materialBean = materialBeanMap.get(prosubItemImport.getTrawlingName()
                                + prosubItemImport.getPriceType()
                                + prosubItemImport.getUnitName() + materialCategoryVo.get(0).getId()
                                + (StringUtils.isNotBlank(prosubItemImport.getJobContent()) ? prosubItemImport.getJobContent() : "")
                                + (StringUtils.isNotBlank(prosubItemImport.getDetailMeasurementRules()) ? prosubItemImport.getDetailMeasurementRules() : ""));
                        if (materialBean == null) {
                            QueryWrapper<LabsubItemEntity> queryWrapper = new QueryWrapper<>();
                            queryWrapper.eq("trawling_name",prosubItemImport.getTrawlingName());
                            if(StringUtils.isNotBlank(prosubItemImport.getPriceType())) {
                                queryWrapper.eq("price_type",prosubItemImport.getPriceType());
                            }
                            queryWrapper.eq("unit_name",prosubItemImport.getUnitName());
                            if(null == prosubItemImport.getJobContent()) {
                                queryWrapper.isNull("job_content");
                            } else {
                                queryWrapper.eq("job_content",prosubItemImport.getJobContent());
                            }
                            if(null == prosubItemImport.getDetailMeasurementRules()) {
                                queryWrapper.isNull("detail_measurement_rules");
                            } else {
                                queryWrapper.eq("detail_measurement_rules",prosubItemImport.getDetailMeasurementRules());
                            }

                            queryWrapper.eq("category_id",materialCategoryVo.get(0).getId());
                            LabsubItemEntity one = null;
                            List<LabsubItemEntity> list = service.list(queryWrapper);
                            if (CollectionUtils.isNotEmpty(list)){
                                one=list.get(0);
                            }
                            if (one != null) {
                                materialBean = BeanMapper.map(one, ProsubItemVO.class);
                                materialBeanMap.put(prosubItemImport.getTrawlingName()
                                        + (StringUtils.isNotBlank(prosubItemImport.getPriceType()) ? prosubItemImport.getPriceType() : "")
                                        + prosubItemImport.getUnitName() + materialCategoryVo.get(0).getId()
                                        + (StringUtils.isNotBlank(prosubItemImport.getJobContent()) ? prosubItemImport.getJobContent() : "")
                                        + (StringUtils.isNotBlank(prosubItemImport.getDetailMeasurementRules()) ? prosubItemImport.getDetailMeasurementRules() : ""), materialBean);
                            }
                        }
                        if (materialBean != null) {
                            prosubItemImport.setRemarks("重复档案！");
                            errorList.add(prosubItemImport);
                            continue;
                        }
                        prosubItemImport.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        prosubItemImport.setCreateTime(new Date());
                        prosubItemImport.setTenantId(InvocationInfoProxy.getTenantid());
                        prosubItemImport.setEnabled(1);
                        successList.add(prosubItemImport);
                    } else {
                        prosubItemImport.setRemarks("档案分类编号不存在！");
                        errorList.add(prosubItemImport);
                    }
                    if (StringUtils.isBlank(datas.get(8))) {
//                        prosubItemImport.setRemarks("成本科目为空！");
//                        errorList.add(prosubItemImport);
//                        continue;
                    }else {
                        String subjectName = datas.get(8).toString();
                        QueryWrapper<SubjectOrgEntity> subjectQueryWrapper = new QueryWrapper<>();
                        subjectQueryWrapper.like("subject_name",subjectName);
                        List<SubjectOrgEntity> list = subjectOrgService.list(subjectQueryWrapper);
                        if(CollectionUtils.isNotEmpty(list)){
                            prosubItemImport.setSubjectId(list.get(0).getId());
                            prosubItemImport.setSubjectName(list.get(0).getSubjectName());
                        }
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @Override
    public CommonResponse<LabsubItemVO> saveOrUpdateLabsubItem(LabsubItemVO saveorUpdateVO) {
        LabsubItemEntity entity = BeanMapper.map(saveorUpdateVO, LabsubItemEntity.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("trawlingCode",new Parameter(QueryParam.EQ, saveorUpdateVO.getTrawlingCode()));
        List<LabsubItemEntity> labsubItemEntities = service.queryList(queryParam);
        if (saveorUpdateVO.getId()!=null){
            if (StringUtils.isEmpty(saveorUpdateVO.getTrawlingCode())){
                return CommonResponse.error("分包档案编码不能为空！");
            }
            LabsubItemEntity labsubItemEntity = service.selectById(saveorUpdateVO.getId());
            if (!labsubItemEntity.getTrawlingCode().equals(saveorUpdateVO.getTrawlingCode())){
                if (CollectionUtils.isNotEmpty(labsubItemEntities)){
                    return CommonResponse.error("分包档案编码重复！");
                }
            }
        }else {
            if (CollectionUtils.isNotEmpty(labsubItemEntities)){
                return CommonResponse.error("分包档案编码重复！");
            }
        }
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {

                // 新增子项未绑定成本科目时 自动带入父级的成本科目
                if(null == entity.getSubjectId()){
                    Long categoryId = entity.getCategoryId();
                    LabsubCategoryEntity labsubCategoryEntity = labsubCategoryService.selectById(categoryId);
                    entity.setSubjectId(labsubCategoryEntity.getSubjectId());
                    entity.setSubjectName(labsubCategoryEntity.getSubjectName());
                }

                if (saveorUpdateVO.getTrawlingCode()==null){
                    entity.setTrawlingCode(billCode.getData());
                }
                entity.setEnabled(0);
                entity.setOrgId(sessionManager.getUserContext().getOrgId());
                entity.setOrgName(sessionManager.getUserContext().getOrgName());
                LabsubCategoryEntity labsubCategoryEntity = labsubCategoryService.selectById(entity.getCategoryId());
                if (labsubCategoryEntity!=null){
                    entity.setCategoryName(labsubCategoryEntity.getCategoryName());
                }
            }
        }
        else{
            LambdaUpdateWrapper<LabsubItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(LabsubItemEntity::getId,saveorUpdateVO.getId());
            updateWrapper.set(LabsubItemEntity::getTrawlingName,saveorUpdateVO.getTrawlingName());
            updateWrapper.set(LabsubItemEntity::getPriceType,saveorUpdateVO.getPriceType());
            updateWrapper.set(LabsubItemEntity::getUnitName,saveorUpdateVO.getUnitName());
            updateWrapper.set(LabsubItemEntity::getJobContent,saveorUpdateVO.getJobContent());
            updateWrapper.set(LabsubItemEntity::getOrgId,sessionManager.getUserContext().getOrgId());
            updateWrapper.set(LabsubItemEntity::getOrgName,sessionManager.getUserContext().getOrgName());
            updateWrapper.set(LabsubItemEntity::getSubjectId,saveorUpdateVO.getSubjectId());
            updateWrapper.set(LabsubItemEntity::getTrawlingCode,saveorUpdateVO.getTrawlingCode());
            updateWrapper.set(LabsubItemEntity::getSubjectName,saveorUpdateVO.getSubjectName());
            updateWrapper.set(LabsubItemEntity::getRemarks,saveorUpdateVO.getRemarks());
            updateWrapper.set(LabsubItemEntity::getDetailMeasurementRules,saveorUpdateVO.getDetailMeasurementRules());
            updateWrapper.set(LabsubItemEntity::getUpdateTime, new Date());
            updateWrapper.set(LabsubItemEntity::getUpdateUserCode, InvocationInfoProxy.getUsercode());
            updateWrapper.set(LabsubItemEntity::getSubjectIds, saveorUpdateVO.getSubjectIds());
            updateWrapper.set(LabsubItemEntity::getSubjectNames, saveorUpdateVO.getSubjectNames());
            updateWrapper.set(LabsubItemEntity::getSubjectRelations, saveorUpdateVO.getSubjectRelations());
            service.update(updateWrapper);
            return CommonResponse.success("保存或修改单据成功！");
        }
        service.saveOrUpdate(entity, false);
        LabsubItemVO vo = BeanMapper.map(entity, LabsubItemVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<LabsubItemVO> queryLabsubItemList(Page<LabsubItemVO> page, QueryWrapper wrapper) {
        return baseMapper.queryProsubItemList(page, wrapper);
    }

    @Override
    public void updateSubject(String subjectIds, String subjectNames, List<Long> ids, String subjectRelations) {
        LambdaUpdateWrapper<LabsubItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(LabsubItemEntity::getId,ids);
        updateWrapper.set(LabsubItemEntity::getSubjectIds, subjectIds);
        updateWrapper.set(LabsubItemEntity::getSubjectNames, subjectNames);
        updateWrapper.set(LabsubItemEntity::getSubjectRelations, subjectRelations);
        service.update(updateWrapper);
    }

    /**
     * 根据叶子结点查询整棵树
     *
     * @param idStr   叶子主键ID，多个叶子结点ID直接使用英文逗号分隔
     * @param type 劳务分包还是专业分包标识：lab-劳务，pro-专业
     */
    @Override
    public CommonResponse<List<Map<String, Object>>> queryWholeTreeItemsById(String idStr, String type) {
        List<Long> idList = Arrays.stream(idStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
        logger.info("LabsubItemServiceImpl***queryWholeTreeItemsById()方法***begin***param：id={}，type={}", idStr, type);
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Map<String, Object>> itemMapList;
        if ("lab".equals(type)) {
            itemMapList = labsubItemMapper.queryLabItemListByIds(idList, tenantId);
        } else {
            itemMapList = prosubItemMapper.queryProItemListByIds(idList, tenantId);
        }
        if (CollectionUtils.isEmpty(itemMapList)) {
            logger.error("查询不到档案数据，param：ids={}，type={}", idStr, type);
            return CommonResponse.error("查询不到档案数据");
        }

        Boolean queryCategoryFlag = false;
        //通过工资单编码查询
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(PLANT_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            logger.error("根据系统参数编码-{}，查询系统参数（档案来源数据是否查询父级分类）配置信息，失败原因：{}", PLANT_CODE, response.getMsg());
            queryCategoryFlag = true;
        }else {
            // 0：否 1：是
            if ("1".equals(response.getData().getValueData())){
                queryCategoryFlag = true;
            }
        }

        // 查询分类表数据
        List<Map<String, Object>> categoryMapList = new ArrayList<>();
        if (queryCategoryFlag){
            List<Long> categoryIdList = new ArrayList<>();
            for (Map<String, Object> itemMap : itemMapList) {
                String innerCode = itemMap.get("innerCode").toString();
                if (StringUtils.isBlank(innerCode)) {
                    logger.error("查询到的innerCode为空，param：ids={}，type={}", idStr, type);
                    return CommonResponse.error("查询到的innerCode为空");
                }
                List<Long> categoryIds = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).collect(Collectors.toList());
                categoryIdList.addAll(categoryIds);
            }
            // 分类ID去重
            categoryIdList = categoryIdList.stream().distinct().collect(Collectors.toList());

            if ("lab".equals(type)) {
                // 劳务分包
                categoryMapList = labsubItemMapper.queryLabCategoryListByCategoryIds(categoryIdList, tenantId);
            } else {
                // 专业分包
                categoryMapList = prosubItemMapper.queryProCategoryListByCategoryIds(categoryIdList, tenantId);
            }
            if (CollectionUtils.isEmpty(categoryMapList) && categoryIdList.size() > 1) {
                logger.error("查询不到分类数据");
                return CommonResponse.error("查询不到分类数据");
            }
            // 分类list去重
            categoryMapList = categoryMapList.stream().distinct().collect(Collectors.toList());
            categoryMapList.forEach(categoryMap -> {
                categoryMap.put("flag", "1");
                categoryMap.put("docId", null);
                // 对于分类表来说，分类ID是自己的主键
                categoryMap.put("id", categoryMap.get("category_id"));
            });
        }



        // 档案list去重
        itemMapList = itemMapList.stream().distinct().collect(Collectors.toList());
        itemMapList.forEach(itemMap -> {
            itemMap.put("docId", Long.parseLong(itemMap.get("id").toString()));
            itemMap.put("flag", "2");
            itemMap.put("category_id", itemMap.get("parentId"));
        });

        // 将档案list和分类list合并
        ArrayList<Map<String, Object>> distinctList = new ArrayList<>();
        distinctList.addAll(categoryMapList);
        distinctList.addAll(itemMapList);
        // 封装返回值数据
        List<Map<String, Object>> resList = new ArrayList<>();
        for (Map<String, Object> en : distinctList) {
            if (MapUtils.isEmpty(en)) {
                continue;
            }
            Map<String, Object> map = new HashMap<>();
            map.put("flag", en.get("flag"));// 区分是档案还是分类
            map.put("detailName", en.get("trawling_name"));// 清单名称
            map.put("unitName", en.get("unit_name"));// 单位
            map.put("detailUnit", en.get("unit_name"));// 单位
            map.put("priceType", en.get("price_type"));// 计量规则
            map.put("jobContent", en.get("job_content"));// 工作内容
            map.put("detailMeasurementRules", en.get("detail_measurement_rules"));// 工作内容
            map.put("id", en.get("id"));// 主键
            map.put("detailCode", en.get("trawling_code"));// 清单编号
            map.put("remarks", en.get("remarks"));// 备注
            map.put("parentId", en.get("parentId"));// 父级ID
            map.put("categoryId", en.get("category_id"));// 分类ID
            map.put("docId", en.get("docId"));// 档案id，档案表的id即为docId，档案分类表中的docId为null
            map.put("unitId", null);// 单位id
//            map.put("detailNum", null);// 工程量
//            map.put("detailPrice", null);// 单价（无税）
            resList.add(map);
        }
        logger.info("LabsubItemServiceImpl***queryWholeTreeItemsById()方法***end***查询档案数据成功，查询结果-{}", JSONObject.toJSONString(resList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        return CommonResponse.success("查询档案数据成功", resList);
    }

    @Override
    public List<LabsubItemVO> queryAllByCategoryIds(List<Long> allCategoryIds, Long tenantId, Integer detailEnabled) {
        return labsubItemMapper.queryAllByCategoryIds(allCategoryIds, tenantId, detailEnabled);
    }

    @Override
    public void getDefaultSubject(List<LabsubItemVO> labsubItemVOS, Long projectId) {
        ProjectSetPoolEntity project = projectSetService.selectById(projectId);

        if(null != project.getSubjectOrgCategoryId()) {
            List<Long> subjectIds = new ArrayList<>(labsubItemVOS.stream().filter(item -> StringUtils.isNotEmpty(item.getSubjectIds())).map(item ->item.getSubjectIds())
                    .flatMap(idStr -> Arrays.stream(idStr.split(","))).map(id -> Long.valueOf(id)).collect(Collectors.toSet()));
            List<SubjectOrgEntity> subjectList = (List<SubjectOrgEntity>) subjectOrgService.listByIds(subjectIds);
            Map<Long, SubjectOrgEntity> subjectMap = subjectList.stream().filter(item -> null != item.getCategoryId()
                    && project.getSubjectOrgCategoryId().equals(item.getCategoryId())).collect(Collectors.toMap(item -> item.getId(), item -> item));

            SubjectOrgEntity tmpSubject = null;
            for(LabsubItemVO m : labsubItemVOS) {
                if(StringUtils.isBlank(m.getSubjectIds())) {
                    continue;
                }
                for(String subjectIdStr : m.getSubjectIds().split(",")) {
                    tmpSubject = subjectMap.get(Long.valueOf(subjectIdStr));
                    if(null != tmpSubject) {
                        m.setSubjectId(tmpSubject.getId());
                        m.setSubjectName(tmpSubject.getSubjectName());
                    }
                }
            }
        }
    }
}
