package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.bean.PriceDepotParamSetEntity;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.service.IpriceDepotParamSetService;
import com.ejianc.foundation.share.vo.PriceDepotParamSetVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/api/priceDepotParamSetApi/")
public class PriceDepotParamSetApi {

    @Autowired
    private IpriceDepotParamSetService service;

    @GetMapping(value = "/queryPriceDepotParamSetList")
    CommonResponse<List<PriceDepotParamSetDTO>> queryPriceDepotParamSetList(@RequestParam(value = "priceDepotType") Integer priceDepotType){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("priceDepotType", new Parameter(QueryParam.EQ, priceDepotType));
        List<PriceDepotParamSetEntity> priceDepotParamSetEntities = service.queryList(queryParam);
        List<PriceDepotParamSetDTO> priceDepotParamSetVOS = BeanMapper.mapList(priceDepotParamSetEntities, PriceDepotParamSetDTO.class);
        for (PriceDepotParamSetDTO record : priceDepotParamSetVOS) {
            if (record.getSource()==1){
                record.setSourceName("合同");
            }if (record.getSource()==2){
                record.setSourceName("结算");
            }
            if (record.getSource()==3){
                record.setSourceName("验收");
            }
            //1:材料价格库 2:周转材价格库 3:设备采购价格库  4:设备租赁价格库 5: 劳务分包价格库 6:专业分包价格库
            if (PrinceDepotEnum.getByCode(record.getPriceDepotType())!=null){
                String priceDepotTypeName = PrinceDepotEnum.getByCode(record.getPriceDepotType()).getName();
                record.setPriceDepotTypeName(priceDepotTypeName);
            }
        }
        return CommonResponse.success("查询成功",priceDepotParamSetVOS);
    }
}
