package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.share.bean.PartDocDetailEntity;
import com.ejianc.foundation.share.vo.PartDocDetailVO;
import com.ejianc.foundation.util.ExcelImportUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.share.mapper.PartDocDetailMapper;
import com.ejianc.foundation.share.service.IPartDocDetailService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 分部分项档案-子表
 * 
 * @author generator
 * 
 */
@Service("partDocDetailService")
public class PartDocDetailServiceImpl extends BaseServiceImpl<PartDocDetailMapper, PartDocDetailEntity> implements IPartDocDetailService{

    @Override
    public CommonResponse<PartDocDetailVO> saveOrUpdate(PartDocDetailVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PartDocDetailEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            List<Long> ids = new ArrayList<>();
            ids.add(saveorUpdateVO.getId());
//            Boolean flag = subjectProjectService.delRefCheck(ids);
//            if (flag) {
//                return CommonResponse.error("存在被引用的核算对象，暂不允许编辑!");
//            }
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<PartDocDetailEntity> lambda = Wrappers.<PartDocDetailEntity>lambdaQuery();
            lambda.eq(PartDocDetailEntity::getCode, saveorUpdateVO.getCode());
            lambda.eq(PartDocDetailEntity::getTenantId, tenantId);
            lambda.ne(PartDocDetailEntity::getId, saveorUpdateVO.getId());
            lambda.eq(PartDocDetailEntity::getPartDocId, saveorUpdateVO.getPartDocId());
            List<PartDocDetailEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error("存在相同编码，不允许保存!");
            }

            entity = BeanMapper.map(saveorUpdateVO, PartDocDetailEntity.class);
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            //校验合同编号是否重复
            LambdaQueryWrapper<PartDocDetailEntity> lambda = Wrappers.<PartDocDetailEntity>lambdaQuery();
            lambda.eq(PartDocDetailEntity::getTenantId, tenantId);
            lambda.eq(PartDocDetailEntity::getCode, saveorUpdateVO.getCode());
            lambda.eq(PartDocDetailEntity::getPartDocId, saveorUpdateVO.getPartDocId());
            List<PartDocDetailEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error("存在相同编码，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, PartDocDetailEntity.class);
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                PartDocDetailEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            //默认最上级父级id为999
//            if(entity.getParentId() == null){
//                entity.setParentId(Long.parseLong(String.valueOf(999)));
////                entity.setParentId(entity.getPartDocId());
//            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }


    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Long partDocId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                //父子关系重复校验
                Map<String, Integer> indexMap = new HashMap<>();
                //父子关系虚拟主键映射
                List<PartDocDetailVO> subjectOrgVOList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                //编码重复校验
                List<String> excelCodeList = new ArrayList<>();
                //查询所有成本科目-集团
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("partDocId", new Parameter(QueryParam.EQ, partDocId));
                List<String> codeList = new ArrayList<>();
                List<PartDocDetailEntity> oldList = super.queryList(queryParam);
                for(PartDocDetailEntity subjectOrgEntity : oldList){
                    codeList.add(subjectOrgEntity.getCode());
                }
                //结果集遍历
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PartDocDetailVO vo = new PartDocDetailVO();
                    vo.setPartDocId(partDocId);
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    //编号
                    String subjectCode = datas.get(0);
                    vo.setCode(subjectCode);
                    //父编号
                    String subjectParentCode = datas.get(1);
                    //维护父子关系(虚拟id)
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    //设置虚拟id
                    vo.setTid(id);
                    //虚拟id映射
                    tidMap.put(subjectCode,id);
                    //设置虚拟父id
                    vo.setTpid(subjectParentCode);
                    //导入数据校验
                    //编码非空
                    if(StringUtils.isEmpty(subjectCode)){
                        vo.setCode(null);
                        warnType = warnType+"编码为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        //编码重复
                        if(codeList.contains(subjectCode)){
                            vo.setCode(subjectCode);
                            warnType = warnType+"编码重复,";
                            flag = true;
                            parentWarn = true;
                        }
                        if(excelCodeList.contains(subjectCode)){
                            vo.setCode(subjectCode);
                            warnType = warnType+"导入编码重复,";
                            flag = true;
                            parentWarn = true;
                        }else{
                            excelCodeList.add(subjectCode);
                        }
                        vo.setCode(subjectCode);
                    }
                    String name = datas.get(2);
                    if(StringUtils.isEmpty(name)){
                        vo.setName(null);
                        warnType = warnType+"名称为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setName(name);
                    }

                    vo.setMemo(datas.get(3));
//                    vo.setEnabled(1);
                    // true=可以导入，false=不可导入
                    vo.setImportFlag(!flag);
                    vo.setParentWarn(parentWarn);
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
//                    vo.setChangeType(3);//增补项

                    subjectOrgVOList.add(vo);
                }
                //此处将之前存储的父级code转换为虚拟父级id
                for(PartDocDetailVO tVo:subjectOrgVOList){
                    if(StringUtils.isNotEmpty(tidMap.get(tVo.getTpid()))){
                        tVo.setTpid(tidMap.get(tVo.getTpid()));
                    }
                }
                List<Map<String, Object>> deailTreeData =ExcelImportUtil.treeData(BeanMapper.mapList(subjectOrgVOList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1),true);
                List<Map<String, Object>> successList=ExcelImportUtil.treeToList(allList.get(0),false);
                resp.put("successList",successList);
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<PartDocDetailVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<PartDocDetailEntity> saveOrUpldates = BeanMapper.mapList(importVOS, PartDocDetailEntity.class);
        super.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        if (saveOrUpldates.size() > 0) {
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (PartDocDetailEntity cdEntity : saveOrUpldates) {
                //存储虚拟id和真实id
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (PartDocDetailEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    //通过虚拟id父子关系存储真实导入id
                    if(idMap.get(cdEntity.getTpid())==null){
                        //tpid不为空且导入中不存在父子关系，查询已存在父id
                        LambdaQueryWrapper<PartDocDetailEntity> lambda = Wrappers.<PartDocDetailEntity>lambdaQuery();
                        lambda.eq(PartDocDetailEntity::getCode, cdEntity.getTpid());
                        PartDocDetailEntity subjectOrgEntity = super.getOne(lambda);
                        if(subjectOrgEntity!=null){
                            cdEntity.setParentId(subjectOrgEntity.getId());
                        }
                    }else{
                        //导入父子关系替换父id
                        cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                    }
                }
            }
            //innercode
            for(PartDocDetailEntity subjectOrgEntity : saveOrUpldates){
                if (subjectOrgEntity.getParentId() != null && subjectOrgEntity.getParentId() > 0) {
                    PartDocDetailEntity uniqueBean = baseMapper.selectById(subjectOrgEntity.getParentId());
                    subjectOrgEntity.setInnerCode(uniqueBean.getInnerCode() + "," + subjectOrgEntity.getId());
                } else {
                    subjectOrgEntity.setInnerCode(subjectOrgEntity.getId().toString());
                }
                super.saveOrUpdate(subjectOrgEntity);
            }
            super.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        return "保存成功！";
    }
    
    
}
