package com.ejianc.foundation.support.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.mapper.BankCategoryMapper;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.vo.BankCategoryVO;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;


/**
 * 银行类别实体
 *
 * @author generator
 */
@Service("bankCategoryService")
public class BankCategoryServiceImpl extends BaseServiceImpl<BankCategoryMapper, BankCategoryEntity> implements IBankCategoryService {

    @Autowired
    private BankCategoryMapper bankCategoryMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SUPPORT_BANK_CATEGORY_CODE";

    @Override
    public List<BankCategoryEntity> queryByName(String name) {
        LambdaQueryWrapper<BankCategoryEntity> lambda = new LambdaQueryWrapper<BankCategoryEntity>();
        lambda.eq(BankCategoryEntity::getName, name);
        lambda.eq(BankCategoryEntity::getDr, 0);
        lambda.eq(BankCategoryEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<BankCategoryEntity> bankCategoryEntities = bankCategoryMapper.selectList(lambda);
        return bankCategoryEntities;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("信息超过10000条，请分批上传！");
                }
                // 处理导入文件
                Map<String, Integer> indexMap = new HashMap<>();
                List<BankCategoryVO> voList = new ArrayList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    String warnType = "";
                    BankCategoryVO bankCategoryVO = new BankCategoryVO();
                    ;
                    bankCategoryVO.setId(IdWorker.getId());
                    //银行编码
                    if (StringUtils.isNotEmpty(datas.get(0))) {
                        LambdaQueryWrapper<BankCategoryEntity> lambda = new LambdaQueryWrapper<BankCategoryEntity>();
                        lambda.eq(BankCategoryEntity::getCode, datas.get(0));
                        lambda.eq(BankCategoryEntity::getTenantId, InvocationInfoProxy.getTenantid());
                        List<BankCategoryEntity> bankCategoryEntities = bankCategoryMapper.selectList(lambda);
                        if (CollectionUtils.isEmpty(bankCategoryEntities)) {
                            bankCategoryVO.setCode(String.valueOf(datas.get(0)));
                        } else {
                            warnType += "[银行分类编码重复]";
                            bankCategoryVO.setCode(datas.get(0));
                        }
                    }
                    //null 编码自动生成
                    else {
                        CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                        if (codeBatchByRuleCode.isSuccess()) {
                            bankCategoryVO.setCode(codeBatchByRuleCode.getData());
                        } else {
                            bankCategoryVO.setCode(String.valueOf(new Date().getTime()));
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(1))) {
                        bankCategoryVO.setName(null);
                        warnType += "[银行类别名称为空]";
                    } else {
                        bankCategoryVO.setName(datas.get(1));
                    }
                    bankCategoryVO.setWarnType(warnType);
                    bankCategoryVO.setMemo(datas.get(2));
                    bankCategoryVO.setRowState("add");
                    voList.add(bankCategoryVO);
                }
                // 处理成功列表和失败列表
                List<BankCategoryVO> successList = new ArrayList<>();
                List<BankCategoryVO> errorList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(voList)) {
                    voList.forEach(vo -> {
                        if (StringUtils.isEmpty(vo.getWarnType())) {
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    });
                }
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<BankCategoryVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<BankCategoryEntity> list = new ArrayList<>();
        for (BankCategoryVO importVO : importVOS) {
            BankCategoryEntity bank = BeanMapper.map(importVO, BankCategoryEntity.class);
            list.add(bank);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            super.saveOrUpdateBatch(list);
        }
        return "保存成功！";
    }

}
