package com.ejianc.foundation.util;

import oracle.jdbc.driver.OracleDriver;
import java.sql.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.exception.BusinessException;

/**
 * Created by liyj on 2020/09/08.
 * JDBC的六大步骤
 * 
 */
public class JdbcOracle {
	
	public static List<SupplierEntity> getSdbjSupplier(String sql,String systemId) {
		Logger logger = LoggerFactory.getLogger("JdbcOracle");
		
		List<SupplierEntity> supplierList = new ArrayList<>();
        Connection connect = null;
        Statement statement = null;
        ResultSet resultSet = null;

        try {
            //第一步：注册驱动
            //利用Driver对象
            Driver driver = new OracleDriver();
            DriverManager.deregisterDriver(driver);

            logger.info("-------------connect sdbj oracle start-----------");
            //第二步：获取连接
            //利用DriverManager
            //水电八局测试环境
//            connect = DriverManager.getConnection("jdbc:oracle:thin:@10.60.231.36:8721:orcl", "MTUSER", "Sdbjtest001$");
            //水电八局生产环境
            connect = DriverManager.getConnection("jdbc:oracle:thin:@10.60.231.45:8721/orcl", "MTUSER", "SdbjinspurDB45GS");
            
            //测试connect正确与否
            System.out.println(connect);  
            System.out.println("链接成功");
            logger.info(connect.toString());
            logger.info("链接成功");
            logger.info("-------------connect sdbj oracle end-----------");

            //PreStatement
            PreparedStatement preState = connect.prepareStatement(sql);
            resultSet = preState.executeQuery();        //执行查询语句
            
			while (resultSet.next()){
				SupplierEntity vo = new SupplierEntity();
				String sourceId = resultSet.getString("LSWLDW_LSWLDWID");//id
			    String socialCreditCode = resultSet.getString("LSWLDW_SH");//社会信用代码
			    String code = resultSet.getString("LSWLDW_WLDWBH");//编码
			    String name = resultSet.getString("LSWLDW_DWMC");//名称
                String state = resultSet.getString("LSWLDW_TYBZ");//停用标志， 0：启用 ， 1停用
//            String name = resultSet.getString("LSWLDW_JC");//简称
			    Date updateTime = resultSet.getDate("LASTMODIFIEDTIME");//最后修改时间
			    Date createTime = resultSet.getDate("CREATEDTIME");//创建时间
			    
			    vo.setEnabled("0".equals(state)?1:0);//供方档案-合作不合作（1：合作 ， 0：不合作）
			    vo.setName(name);
			    vo.setCode(code);
			    vo.setSourceId(sourceId.replaceAll("-", ""));
			    vo.setSocialCreditCode(socialCreditCode);
			    vo.setSystemId(systemId);
			    vo.setUpdateTime(updateTime);
			    vo.setCreateTime(createTime);
			    supplierList.add(vo);
			}
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("-------------connect sdbj oracle fail-----------");
            logger.info(e.toString());
            throw new BusinessException(e);
        }finally {
            //第六步：关闭资源
                try {
                    if (resultSet!=null) resultSet.close();
                    if (statement!=null) statement.close();
                    if (connect!=null) connect.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
        }
		return supplierList;
	}
	
}