package com.ejianc.business.signaturemanage.api;


import com.ejianc.business.signaturemanage.hystrix.SignatureManageHystrix;
import com.ejianc.business.signaturemanage.vo.InitSignatoryVO;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.PrivateSignUrlVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

@FeignClient(name = "ejc-signaturemanage-web", url = "${common.env.feign-client-url}", path = "ejc-signaturemanage-web", fallback = SignatureManageHystrix.class)
public interface ISignatureManageApi {

    /**
     * 契约锁，发起方状态回调
     *
     * @param map
     * @return
     */
    @PostMapping(value = "/api/signaturemanage/qysCallBack/organizer")
    CommonResponse<String> organizer(@RequestParam Map<String, String> map);


    /**
     * 发起签章
     * 1.创建合同文档
     * 2.创建合同
     * 3.获取下一个待签章的人员列表
     * 4.推送消息通知
     *
     * @param initSignatureVO 发起签章VO
     * @return contractId
     */
    @PostMapping(value = "/api/signaturemanage/sendSignature")
    CommonResponse<Long> initiateSignature(@RequestBody InitSignatureVO initSignatureVO);


    /**
     * 获取私有云合同签署短链接
     *
     * @param privateSignUrlVO
     * @return privateSignUrl
     */
    @PostMapping(value = "/api/signaturemanage/getPrivateSignUrl")
    CommonResponse<String> privateSignUrl(@RequestBody PrivateSignUrlVO privateSignUrlVO);


    /**
     * 下载签章文件
     *
     * @param billId
     * @param response
     */
    @GetMapping(value = "/api/signaturemanage/downloadHasSignedFile")
    void downloadHasSignedFile(@RequestParam(value = "billId") Long billId, HttpServletResponse response);


    /**
     * 合同预览
     *
     * @param billId
     * @param status
     * @return
     */
    @Deprecated
    @GetMapping(value = "/api/signaturemanage/previewContract")
    CommonResponse<List<SignMgrPreviewVO>> previewContract(@RequestParam(value = "billId") Long billId, @RequestParam(value = "status") List<String> status);


    /**
     * 签章详情
     *
     * @param billId
     * @return
     */
    @GetMapping(value = "/api/signaturemanage/signDetail")
    CommonResponse<List<InitSignatoryVO>> signDetail(@RequestParam(value = "billId") Long billId);

}
