package com.ejianc.business.signaturemanage.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 签章管理
 *
 * @author generator
 */
public class SignMgrVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer delFlag; // 0-未删除，1-已删除
    private Long billId; // 业务id
    private String billType; // 来源业务单据类型
    private String billCode; // 单据编号
    private String billName; // 单据名称
    private String contractName; // 合同名称
    private BigDecimal contractTaxMny; // 合同金额(含税)
    private Long orgId; // 组织id
    private String orgCode; // 组织编号
    private String orgName; // 组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编号
    private String projectName; // 项目名称
    private String billRefCode; // refcode
    private Long sourceBillId; // 业务id（第三方系统返回的）
    private Long sourceDocId; // 业务文档id（第三方系统返回的）
    private Long billDocId; // 业务文件id
    private String billDocumentName; // 业务文件名称
    private String billDocumentType; // 业务文件类型
    private String signRequirements; // 签署要求
    private String creatorName; // 创建人名称
    private String creatorContact; // 创建人联系方式
    private String tenantName; // 发起方名称
    private String subject; // 主题 (签章主题：PM系统：单据名称-单据编号)

    private List<SignMgrSignatoryVO> signMgrSignatoryEntities = new ArrayList<>(); // 签章管理-签署方子表

    public Integer getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    /**
     * 业务id
     */
    public Long getBillId() {
        return billId;
    }

    /**
     * 业务id
     */
    public void setBillId(Long billId) {
        this.billId = billId;
    }

    /**
     * 来源业务单据类型
     */
    public String getBillType() {
        return billType;
    }

    /**
     * 来源业务单据类型
     */
    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * refcode
     */
    public String getBillRefCode() {
        return billRefCode;
    }

    /**
     * refcode
     */
    public void setBillRefCode(String billRefCode) {
        this.billRefCode = billRefCode;
    }

    /**
     * 业务id（第三方系统返回的）
     */
    public Long getSourceBillId() {
        return sourceBillId;
    }

    /**
     * 业务id（第三方系统返回的）
     */
    public void setSourceBillId(Long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }

    /**
     * 业务文档id（第三方系统返回的）
     */
    public Long getSourceDocId() {
        return sourceDocId;
    }

    /**
     * 业务文档id（第三方系统返回的）
     */
    public void setSourceDocId(Long sourceDocId) {
        this.sourceDocId = sourceDocId;
    }

    /**
     * 业务文件id
     */
    public Long getBillDocId() {
        return billDocId;
    }

    /**
     * 业务文件id
     */
    public void setBillDocId(Long billDocId) {
        this.billDocId = billDocId;
    }

    /**
     * 业务文件名称
     */
    public String getBillDocumentName() {
        return billDocumentName;
    }

    /**
     * 业务文件名称
     */
    public void setBillDocumentName(String billDocumentName) {
        this.billDocumentName = billDocumentName;
    }

    /**
     * 业务文件类型
     */
    public String getBillDocumentType() {
        return billDocumentType;
    }

    /**
     * 业务文件类型
     */
    public void setBillDocumentType(String billDocumentType) {
        this.billDocumentType = billDocumentType;
    }

    /**
     * 签署要求
     */
    public String getSignRequirements() {
        return signRequirements;
    }

    /**
     * 签署要求
     */
    public void setSignRequirements(String signRequirements) {
        this.signRequirements = signRequirements;
    }

    /**
     * 创建人名称
     */
    public String getCreatorName() {
        return creatorName;
    }

    /**
     * 创建人名称
     */
    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    /**
     * 创建人联系方式
     */
    public String getCreatorContact() {
        return creatorContact;
    }

    /**
     * 创建人联系方式
     */
    public void setCreatorContact(String creatorContact) {
        this.creatorContact = creatorContact;
    }

    /**
     * 发起方名称
     */
    public String getTenantName() {
        return tenantName;
    }

    /**
     * 发起方名称
     */
    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    /**
     * 签章管理-签署方子表
     */
    public List<SignMgrSignatoryVO> getSignMgrSignatoryEntities() {
        return signMgrSignatoryEntities;
    }

    /**
     * 签章管理-签署方子表
     */
    public void setSignMgrSignatoryEntities(List<SignMgrSignatoryVO> signMgrSignatoryEntities) {
        this.signMgrSignatoryEntities = signMgrSignatoryEntities;
    }

}
