/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton;

import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public class MybatisRedisCache
implements Cache {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private String id;
    private static final Integer redisTimeout = 5;

    public MybatisRedisCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        RedisTemplate redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        if (value != null) {
            redisTemplate.opsForValue().set((Object)key.toString(), value, (long)redisTimeout.intValue(), TimeUnit.MINUTES);
        }
    }

    public Object getObject(Object key) {
        RedisTemplate redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        try {
            if (key != null) {
                return redisTemplate.opsForValue().get((Object)key.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object removeObject(Object key) {
        RedisTemplate redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        if (key != null) {
            redisTemplate.delete((Object)key.toString());
        }
        return null;
    }

    public void clear() {
        RedisTemplate redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        Set keys = redisTemplate.keys((Object)("*:" + this.id + "*"));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            redisTemplate.delete((Collection)keys);
        }
    }

    public int getSize() {
        RedisTemplate redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        Long size = (Long)redisTemplate.execute(RedisServerCommands::dbSize);
        return size.intValue();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

