/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.refer.serialize;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private static final Logger Log = LoggerFactory.getLogger(ReferSerializer.class);
    private String referCode;
    private String[] referCodes;
    private String[] extraFileds;
    private static final String DEFDOC_REFER_CODE = "defdoc";

    public ReferSerializer(String referCode, String[] referCodes, String[] extraFileds) {
        this.referCode = referCode;
        this.referCodes = referCodes;
        this.extraFileds = extraFileds;
    }

    public ReferSerializer() {
    }

    public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        String[] ids;
        String[] stringArray = ids = StringUtils.isEmpty((CharSequence)value) ? null : value.split(",");
        if (ids != null && ids.length > 0) {
            boolean isSingle = ids.length == 1 && value.indexOf(",") == -1;
            JSONArray jsonArray = null;
            try {
                jsonArray = ReferObjectUtil.getReferEntityValue(Arrays.asList(ids), this.referCode, this.referCodes, this.extraFileds);
            }
            catch (Exception e) {
                Log.error("referCode:" + this.referCode + " id\uff1a" + value + "\u8f6c\u6362\u51fa\u9519\uff0c--" + e.getMessage(), (Throwable)e);
            }
            if (jsonArray != null && jsonArray.size() > 0) {
                if (isSingle) {
                    jgen.writeObject(jsonArray.get(0));
                } else {
                    jgen.writeObject((Object)jsonArray);
                }
            } else {
                JSONObject result = new JSONObject();
                result.put("id", (Object)value);
                result.put("code", (Object)value);
                result.put("name", (Object)value);
                if (isSingle) {
                    jgen.writeObject((Object)result);
                } else {
                    jsonArray = new JSONArray();
                    jsonArray.add((Object)result);
                    jgen.writeObject((Object)jsonArray);
                }
            }
        } else {
            jgen.writeObject(null);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            AnnotatedMethod method;
            ReferSerialTransfer referSerialTransfer;
            if (Objects.equals(beanProperty.getType().getRawClass(), String.class) && (referSerialTransfer = (method = (AnnotatedMethod)beanProperty.getMember()).getAnnotated().getDeclaredAnnotation(ReferSerialTransfer.class)) != null) {
                String referCode = referSerialTransfer.referCode();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referCode}) && (DEFDOC_REFER_CODE.equalsIgnoreCase(referCode) || referCode.toLowerCase().startsWith(DEFDOC_REFER_CODE))) {
                    referCode = DEFDOC_REFER_CODE;
                }
                return new ReferSerializer(referCode, referSerialTransfer.referCodes(), referSerialTransfer.extraFileds());
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(beanProperty);
    }
}

