package com.ejianc.framework.skeleton;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import org.apache.ibatis.cache.Cache;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

import com.ejianc.framework.skeleton.refer.util.ContextUtil;

/**
 * 使用redis作为mybatis-plus的二级缓存
 */
@SuppressWarnings("unchecked")
public class MybatisRedisCache implements Cache {
    // 读写锁
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private String id;
    private final static Integer redisTimeout = 5;

    public MybatisRedisCache(final String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }
    
	@Override
    public void putObject(Object key, Object value) {
    	RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        if (value != null) {
            redisTemplate.opsForValue().set(key.toString(), value, redisTimeout, TimeUnit.MINUTES);
        }
    }

    @Override
    public Object getObject(Object key) {
    	RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        try {
            if (key != null) {
                return redisTemplate.opsForValue().get(key.toString());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Object removeObject(Object key) {
    	RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        if (key != null) {
            redisTemplate.delete(key.toString());
        }
        return null;
    }

    @Override
    public void clear() {
    	RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        Set<String> keys = redisTemplate.keys("*:" + this.id + "*");
        if (!CollectionUtils.isEmpty(keys)) {
            redisTemplate.delete(keys);
        }
    }

    @Override
    public int getSize() {
    	RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("mpRedisTemplate", RedisTemplate.class);
        Long size = redisTemplate.execute((RedisCallback<Long>) RedisServerCommands::dbSize);
        return size.intValue();
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}