package com.ejianc.framework.skeleton.refer.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import com.ejianc.framework.skeleton.refer.serialize.ReferSerializer;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 组合注解 将id转换成json{id:xx,code:xx,name:xx}
 * 
 * @author guominga
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@JacksonAnnotationsInside
@JsonSerialize(using = ReferSerializer.class)
public @interface ReferSerialTransfer {
	/**
	 * 转换实体对对应的引用code；referCode和referCodes同时存在优先referCode
	 * 
	 * @return
	 */
	public String referCode() default "";
	/**
	 * 转换实体对对应的引用编码数据；referCode和referCodes同时存在优先referCode
	 * 
	 * @return
	 */
	public String[] referCodes() default {};

	
	/**
	 * 实体中除了（id，code，name，parentId）之外的其他字段
	 * 
	 * @return
	 */
	public String[] extraFileds() default {};
}
