package com.ejianc.framework.skeleton.refer.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.client.ClientProtocolException;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;

/**
 * 根据redis和http rest 托底获取参照实体信息
 * 
 * @author guominga 2020年02月13日
 *
 */
public class ReferObjectUtil {

	/**
	 * 
	 * @param valueId
	 *            单个档案直接传:id，多个id传: id1,id2,id3
	 * @param referCode
	 * @return
	 * @throws IOException
	 * @throws GeneralSecurityException
	 * @throws ClientProtocolException
	 */
	private static JSONArray getReferEntityValue(List<String> valueIds, String referCode, String[] extraFileds)
			throws Exception {
		JSONArray jsonArray = null;
		if (valueIds != null && valueIds.size() > 0) {
			// 走redis
			List<Object> objKeys = new ArrayList<>();
			for (String id : valueIds) {
				String key = referCode + id;
				objKeys.add(key);
			}
			JedisCacheTool cacheTool = ContextUtil.getBean(JedisCacheTool.class);
			Map<Object, Object> resultMap = cacheTool.getBatch(objKeys);
			// redis返回数量和参数数量一致
			if (resultMap.size() == valueIds.size()) {
				jsonArray = new JSONArray();
				for (String id : valueIds) {
					String key = referCode + id;
					JSONObject jsonObj = (JSONObject) resultMap.get(key);
					jsonArray.add(jsonObj);
				}
			} else {
				String referUrl = getReferRestUrl(referCode);
				Map<String, Object> valueparams = new HashMap<>();
				valueparams.put("valueIds", StringUtils.collectionToCommaDelimitedString(valueIds));
				valueparams.put("referCode", referCode);
				String url = referUrl + "/commonrefer/getrefervalueLst";
				//String url = "http://127.0.0.1:9001/icop-share-web/" + "/commonrefer/getrefervalueLst";
				String jsonbackstr = ReferHttpClientUtils.getAndHeader(url, valueparams);
				jsonArray = JSON.parseArray(jsonbackstr);
			}
		}
		if (jsonArray == null)
			return null;
		JSONArray jsonArrayView = null;
		// 只传id.code,name,parentid
		if (extraFileds == null || extraFileds.length == 0) {
			jsonArrayView = new JSONArray();
			Iterator<Object> it = jsonArray.iterator();
			while (it.hasNext()) {
				JSONObject jsonObj = (JSONObject) it.next();
				JSONObject jsonObjView = new JSONObject();
				jsonObjView.put(ReferConstant.REFER_ID, jsonObj.get(ReferConstant.REFER_ID));
				jsonObjView.put(ReferConstant.REFER_CODE, jsonObj.get(ReferConstant.REFER_CODE));
				jsonObjView.put(ReferConstant.REFER_NAME, jsonObj.get(ReferConstant.REFER_NAME));
				jsonObjView.put(ReferConstant.REFER_PARENTID, jsonObj.get(ReferConstant.REFER_PARENTID));
				jsonArrayView.add(jsonObjView);
			}
			return jsonArrayView;
		}
		// 取所有字段
		else if (Arrays.asList(extraFileds).contains(ReferConstant.REFER_ALL)) {
			return jsonArray;
		}
		// id.code,name,parentid加上extraFileds的字段
		else {
			jsonArrayView = new JSONArray();
			Iterator<Object> it = jsonArray.iterator();
			while (it.hasNext()) {
				JSONObject jsonObj = (JSONObject) it.next();
				JSONObject jsonObjView = new JSONObject();
				for (int i = 0; i < extraFileds.length; i++) {
					if (jsonObj.containsKey(extraFileds[i]))
						jsonObjView.put(extraFileds[i], jsonObj.get(extraFileds[i]));
				}
				jsonObjView.put(ReferConstant.REFER_ID, jsonObj.get(ReferConstant.REFER_ID));
				jsonObjView.put(ReferConstant.REFER_CODE, jsonObj.get(ReferConstant.REFER_CODE));
				jsonObjView.put(ReferConstant.REFER_NAME, jsonObj.get(ReferConstant.REFER_NAME));
				jsonObjView.put(ReferConstant.REFER_PARENTID, jsonObj.get(ReferConstant.REFER_PARENTID));
				jsonArrayView.add(jsonObjView);
			}
			return jsonArrayView;
		}

	}

	/**
	 * 
	 * @param valueId
	 *            单个档案直接传:id，多个id传: id1,id2,id3
	 * @param referCode
	 * @return只查id，code，name
	 * @throws Exception
	 */
	public static JSONArray getReferEntityValue(List<String> valueIds, String referCode) throws Exception {
		return getReferEntityValue(valueIds, referCode, null, null);
	}

	/**
	 * 
	 * @param valueId
	 *            单个档案直接传:id，多个id传: id1,id2,id3
	 * @param referCodes
	 *            多个code
	 * @return
	 * @return
	 * @return
	 * @throws Exception
	 */
	public static JSONArray getReferEntityValue(List<String> valueIds, String referCode, String[] referCodes,
			String[] extraFileds) throws Exception {
		if (valueIds == null || valueIds.isEmpty())
			return null;
		if (!StringUtils.isEmpty(referCode)) {
			JSONArray jSONArray = getReferEntityValue(valueIds, referCode, extraFileds);
			return jSONArray;
		}
		if (!ArrayUtils.isEmpty(referCodes))
			for (String childReferCode : referCodes) {
				JSONArray jSONArray = getReferEntityValue(valueIds, childReferCode, extraFileds);
				if (jSONArray != null && !jSONArray.isEmpty())
					return jSONArray;

			}
		return null;
	}

	/**
	 * 通过元数据服务获取实体信息
	 * 
	 * @param className
	 * @return
	 */
	private static String getReferRestUrl(String referCode) {
		String url = null;
		MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
		String backData = null;
		try {
			backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
		} catch (ClientProtocolException e) {
			ExceptionUtil.wrappException(e);
		} catch (GeneralSecurityException e) {
			ExceptionUtil.wrappException(e);
		} catch (IOException e) {
			ExceptionUtil.wrappException(e);
		}

		JSONObject jsonobject = JSON.parseObject(backData);
		if (jsonobject.getString("url") == null) {
			ExceptionUtil.wrappBusinessException("参照编码" + referCode + "的实体没有发布元数据!");
		}
		url = jsonobject.getString("url").replace("impl", "web");
		return url;

	}
}
