package com.ejianc.framework.skeleton.template;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;

/**
 * 业务bean超类
 * 
 * @author guominga
 *
 */
public class BaseEntity implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键ID
	 */
	@TableField(fill = FieldFill.INSERT)
	@TableId(type = IdType.NONE)
	private Long id;

	/**
	 * 创建者账号
	 */
	@TableField(value = "create_user_code", fill = FieldFill.INSERT)
	private String createUserCode;

	/**
	 * 创建时间
	 */
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	/**
	 * 修改者账号
	 */
	@TableField(value = "update_user_code", fill = FieldFill.UPDATE)
	private String updateUserCode;

	/**
	 * 修改时间
	 */
	@TableField(value = "update_time", fill = FieldFill.UPDATE)
	private Date updateTime;

	/**
	 * 删除标识（0：未删， 1：删除）
	 */
	@TableLogic
	@TableField(value = "dr")
	private Integer dr;

	/**
	 * 租户ID
	 */
	@TableField(value = "tenant_id", fill = FieldFill.INSERT)
	private Long tenantId;
	
	/**
	 * 是否同步es
	 */
	@TableField(value = "sync_es_flag")
	private Integer syncEsFlag;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getCreateUserCode() {
		return createUserCode;
	}

	public void setCreateUserCode(String createUserCode) {
		this.createUserCode = createUserCode;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getUpdateUserCode() {
		return updateUserCode;
	}

	public void setUpdateUserCode(String updateUserCode) {
		this.updateUserCode = updateUserCode;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public Integer getDr() {
		return dr;
	}

	public void setDr(Integer dr) {
		this.dr = dr;
	}

	public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

	public Integer getSyncEsFlag() {
		return syncEsFlag;
	}

	public void setSyncEsFlag(Integer syncEsFlag) {
		this.syncEsFlag = syncEsFlag;
	}
	
	

}
