/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.advice;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.exception.ErrorEnum;
import com.ejianc.framework.core.kit.base.ExceptionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String SERV_ERROR_MSG = "\u540e\u53f0\u670d\u52a1\u62a5\u9519\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01";

    CommonResponse<String> genResponse(String msg, String data) {
        CommonResponse ret = CommonResponse.error((int)ErrorEnum.STATUS_PARAM_ERROR.getErrorCode(), (String)ErrorEnum.STATUS_PARAM_ERROR.getErrorMsg());
        ret.setData((Object)data);
        return ret;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public CommonResponse<String> resolveMissingServletRequestParameterException(MissingServletRequestParameterException ex) {
        this.logger.error(ExceptionUtil.toStringWithRootCause((Throwable)ex));
        this.logger.error("\u53c2\u6570{}\u5fc5\u987b\u4f20\u9012", (Object)ex.getParameterName());
        String msg = ex.getMessage();
        return this.genResponse("\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef", msg);
    }

    @ExceptionHandler(value={UnrecognizedPropertyException.class})
    public CommonResponse<String> resolveUnrecognizedPropertyException(UnrecognizedPropertyException ex) {
        this.logger.error(ExceptionUtil.toStringWithRootCause((Throwable)ex));
        this.logger.error("\u53c2\u6570{}\u65e0\u6cd5\u89e3\u6790", (Object)ex.getPropertyName());
        String msg = ex.getMessage();
        return this.genResponse("\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef", msg);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public CommonResponse<String> resolveConstraintViolationException(ConstraintViolationException ex) {
        this.logger.error(ExceptionUtil.toStringWithRootCause((Throwable)ex));
        String msg = ex.getMessage();
        Set constraintViolations = ex.getConstraintViolations();
        if (!CollectionUtils.isEmpty((Collection)constraintViolations)) {
            StringBuilder msgBuilder = new StringBuilder();
            for (ConstraintViolation constraintViolation : constraintViolations) {
                msgBuilder.append(constraintViolation.getMessage()).append(",");
            }
            String errorMessage = msgBuilder.toString();
            if (errorMessage.length() > 1) {
                errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
            }
            msg = errorMessage;
        }
        return this.genResponse("\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef", msg);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public CommonResponse<String> resolveMethodArgumentNotValidException(MethodArgumentNotValidException ex) {
        this.logger.error(ExceptionUtil.toStringWithRootCause((Throwable)ex));
        BindingResult result = ex.getBindingResult();
        List objectErrors = result.getAllErrors();
        String msg = ex.getMessage();
        if (!CollectionUtils.isEmpty((Collection)objectErrors)) {
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append(result.getObjectName()).append(":");
            for (ObjectError objectError : objectErrors) {
                msgBuilder.append(objectError.getDefaultMessage()).append(",");
            }
            String errorMessage = msgBuilder.toString();
            if (errorMessage.length() > 1) {
                errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
            }
            msg = errorMessage;
        }
        return this.genResponse("\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef", msg);
    }

    @ExceptionHandler(value={Exception.class})
    public CommonResponse<ErrorEnum> exceptionHandler(HttpServletRequest request, Exception e) {
        Throwable throwable = this.getBusinessException(e);
        if (!Objects.isNull(throwable)) {
            Integer errorCode = ((BusinessException)throwable).getErrorCode();
            String errorMsg = ((BusinessException)throwable).getErrorMsg();
            if (errorCode != null && StringUtils.isNotBlank((CharSequence)ErrorEnum.getErrorMsgByCode((Integer)errorCode))) {
                if (StringUtils.isBlank((CharSequence)errorMsg)) {
                    errorMsg = ErrorEnum.getErrorMsgByCode((Integer)errorCode);
                }
                return CommonResponse.error((int)errorCode, (String)errorMsg);
            }
        }
        return CommonResponse.error((String)SERV_ERROR_MSG);
    }

    private Throwable getBusinessException(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof BusinessException) {
            e.printStackTrace();
            this.logger.error("\u65b9\u6cd5\u5f02\u5e38[{}]", e.getCause());
            Throwable temp = this.getBusinessException(e.getCause());
            if (temp == null) {
                return e;
            }
            return temp;
        }
        this.logger.error("\u65b9\u6cd5\u5f02\u5e38[{}]", e.getCause());
        e.printStackTrace();
        return this.getBusinessException(e.getCause());
    }
}

