/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.refer.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.JedisCacheTool;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.client.ClientProtocolException;
import org.springframework.util.StringUtils;

public class ReferObjectUtil {
    private static JSONArray getReferEntityValue(List<String> valueIds, String referCode, String[] extraFileds) throws Exception {
        JSONObject jsonObjView;
        JSONArray jsonArray = null;
        if (valueIds != null && valueIds.size() > 0) {
            ArrayList<Object> objKeys = new ArrayList<Object>();
            for (String id : valueIds) {
                String key = referCode + id;
                objKeys.add(key);
            }
            JedisCacheTool cacheTool = ContextUtil.getBean(JedisCacheTool.class);
            Map<Object, Object> resultMap = cacheTool.getBatch(objKeys);
            if (resultMap.size() == valueIds.size()) {
                jsonArray = new JSONArray();
                for (String id : valueIds) {
                    String key = referCode + id;
                    JSONObject jsonObj = (JSONObject)resultMap.get(key);
                    jsonArray.add((Object)jsonObj);
                }
            } else {
                String referUrl = ReferObjectUtil.getReferRestUrl(referCode);
                HashMap<String, String> valueparams = new HashMap<String, String>();
                valueparams.put("valueIds", StringUtils.collectionToCommaDelimitedString(valueIds));
                valueparams.put("referCode", referCode);
                String url = referUrl + "/commonrefer/getrefervalueLst";
                String jsonbackstr = ReferHttpClientUtils.getAndHeader(url, valueparams);
                jsonArray = JSON.parseArray((String)jsonbackstr);
            }
        }
        if (jsonArray == null) {
            return null;
        }
        JSONArray jsonArrayView = null;
        if (extraFileds == null || extraFileds.length == 0) {
            jsonArrayView = new JSONArray();
            for (JSONObject jsonObj : jsonArray) {
                jsonObjView = new JSONObject();
                jsonObjView.put("id", jsonObj.get((Object)"id"));
                jsonObjView.put("code", jsonObj.get((Object)"code"));
                jsonObjView.put("name", jsonObj.get((Object)"name"));
                jsonObjView.put("parentId", jsonObj.get((Object)"parentId"));
                jsonArrayView.add((Object)jsonObjView);
            }
            return jsonArrayView;
        }
        if (Arrays.asList(extraFileds).contains("allfields")) {
            return jsonArray;
        }
        jsonArrayView = new JSONArray();
        for (JSONObject jsonObj : jsonArray) {
            jsonObjView = new JSONObject();
            for (int i = 0; i < extraFileds.length; ++i) {
                if (!jsonObj.containsKey((Object)extraFileds[i])) continue;
                jsonObjView.put(extraFileds[i], jsonObj.get((Object)extraFileds[i]));
            }
            jsonObjView.put("id", jsonObj.get((Object)"id"));
            jsonObjView.put("code", jsonObj.get((Object)"code"));
            jsonObjView.put("name", jsonObj.get((Object)"name"));
            jsonObjView.put("parentId", jsonObj.get((Object)"parentId"));
            jsonArrayView.add((Object)jsonObjView);
        }
        return jsonArrayView;
    }

    public static JSONArray getReferEntityValue(List<String> valueIds, String referCode) throws Exception {
        return ReferObjectUtil.getReferEntityValue(valueIds, referCode, null, null);
    }

    public static JSONArray getReferEntityValue(List<String> valueIds, String referCode, String[] referCodes, String[] extraFileds) throws Exception {
        if (valueIds == null || valueIds.isEmpty()) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)referCode)) {
            JSONArray jSONArray = ReferObjectUtil.getReferEntityValue(valueIds, referCode, extraFileds);
            return jSONArray;
        }
        if (!ArrayUtils.isEmpty((Object[])referCodes)) {
            for (String childReferCode : referCodes) {
                JSONArray jSONArray = ReferObjectUtil.getReferEntityValue(valueIds, childReferCode, extraFileds);
                if (jSONArray == null || jSONArray.isEmpty()) continue;
                return jSONArray;
            }
        }
        return null;
    }

    private static String getReferRestUrl(String referCode) {
        String url = null;
        MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
        }
        catch (ClientProtocolException e) {
            ExceptionUtil.wrappException((Exception)((Object)e));
        }
        catch (GeneralSecurityException e) {
            ExceptionUtil.wrappException(e);
        }
        catch (IOException e) {
            ExceptionUtil.wrappException(e);
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("url") == null) {
            ExceptionUtil.wrappBusinessException("\u53c2\u7167\u7f16\u7801" + referCode + "\u7684\u5b9e\u4f53\u6ca1\u6709\u53d1\u5e03\u5143\u6570\u636e!");
        }
        url = jsonobject.getString("url").replace("impl", "web");
        return url;
    }
}

