/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template.es;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.es.IBaseEsQueryDao;
import com.ejianc.framework.skeleton.template.es.TableInfoTool;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BaseEsQueryDao<T>
implements IBaseEsQueryDao<T> {
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String ASC = "asc";
    @Autowired(required=false)
    private RestHighLevelClient client;

    private Class<T> getTClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public Long selectCount(QueryParam queryParam) {
        Long total = 0L;
        TableInfo tableInfo = TableInfoTool.initTableInfo(this.getTClass());
        String index = tableInfo.getTableName();
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)((String)entry.getKey()), (Object)param.getValue()));
        }
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            total = this.client.search(searchRequest, RequestOptions.DEFAULT).getHits().getTotalHits();
            return total;
        }
        catch (Exception e) {
            throw new BusinessException("\u6839\u636e \u53c2\u6570map \u6761\u4ef6\uff0c\u67e5\u8be2\u603b\u8bb0\u5f55\u6570\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e.getMessage());
        }
    }

    @Override
    public List<T> selectList(QueryParam queryParam) {
        ArrayList<Object> list = new ArrayList<Object>();
        TableInfo tableInfo = TableInfoTool.initTableInfo(this.getTClass());
        String index = tableInfo.getTableName();
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)((String)entry.getKey()), (Object)parameter.getValue()));
        }
        Map orderMap = queryParam.getOrderMap();
        if (orderMap != null && !orderMap.isEmpty()) {
            for (Map.Entry entry : orderMap.entrySet()) {
                sourceBuilder.sort(new FieldSortBuilder((String)entry.getKey()).order(ASC.equals(((String)entry.getValue()).toLowerCase()) ? SortOrder.ASC : SortOrder.DESC));
            }
        }
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits searchHits = searchResponse.getHits();
            for (SearchHit hit : searchHits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, this.getTClass()));
            }
            return list;
        }
        catch (Exception exception) {
            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + exception.getMessage());
        }
    }

    @Override
    public IPage<T> selectPage(IPage<T> page, QueryParam queryParam) {
        TableInfo tableInfo = TableInfoTool.initTableInfo(this.getTClass());
        String index = tableInfo.getTableName();
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)((String)entry.getKey()), (Object)parameter.getValue()));
        }
        Map orderMap = queryParam.getOrderMap();
        if (orderMap != null && !orderMap.isEmpty()) {
            for (Map.Entry entry : orderMap.entrySet()) {
                sourceBuilder.sort(new FieldSortBuilder((String)entry.getKey()).order(ASC.equals(((String)entry.getValue()).toLowerCase()) ? SortOrder.ASC : SortOrder.DESC));
            }
        }
        sourceBuilder.from((int)page.getCurrent());
        sourceBuilder.size((int)page.getSize());
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            Iterator iterator = hits.iterator();
            while (iterator.hasNext()) {
                SearchHit hit = (SearchHit)iterator.next();
                String sourceAsString = hit.getSourceAsString();
                arrayList.add(JSON.parseObject((String)sourceAsString, this.getTClass()));
            }
            page.setRecords(arrayList);
        }
        catch (Exception exception) {
            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + exception.getMessage());
        }
        SearchRequest searchRequest2 = new SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)((String)entry.getKey()), (Object)param.getValue()));
        }
        searchSourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest2.source(searchSourceBuilder);
        try {
            SearchResponse response = this.client.search(searchRequest2, RequestOptions.DEFAULT);
            page.setTotal(response.getHits().getTotalHits());
        }
        catch (Exception e) {
            throw new BusinessException("\u6839\u636e \u53c2\u6570map \u6761\u4ef6\uff0c\u67e5\u8be2\u603b\u8bb0\u5f55\u6570\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e.getMessage());
        }
        return page;
    }
}

