/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template.es;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableInfoTool {
    private static Logger logger = LoggerFactory.getLogger(TableInfoTool.class);

    public static TableInfo initTableInfo(Class<?> clazz) {
        TableInfo tableInfo = new TableInfo();
        TableInfoTool.initTableName(clazz, tableInfo);
        TableInfoTool.initTableFields(clazz, tableInfo);
        return tableInfo;
    }

    static void initTableName(Class<?> clazz, TableInfo tableInfo) {
        TableName table = clazz.getAnnotation(TableName.class);
        String tableName = clazz.getSimpleName();
        tableName = table != null && StringUtils.isNotEmpty((CharSequence)table.value()) ? table.value() : StringUtils.camelToUnderline((String)tableName);
        tableInfo.setTableName(tableName);
    }

    static void initTableFields(Class<?> clazz, TableInfo tableInfo) {
        GlobalConfig globalConfig = GlobalConfigUtils.defaults();
        List<Field> list = TableInfoTool.getAllFields(clazz);
        boolean isReadPK = false;
        boolean existTableId = TableInfoTool.isExistTableId(list);
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>();
        for (Field field : list) {
            if (!isReadPK && (isReadPK = existTableId ? TableInfoTool.initTableIdWithAnnotation(tableInfo, field, clazz) : TableInfoTool.initTableIdWithoutAnnotation(tableInfo, field, clazz)) || TableInfoTool.initTableFieldWithAnnotation(globalConfig.getDbConfig(), tableInfo, fieldList, field, clazz)) continue;
            fieldList.add(new TableFieldInfo(globalConfig.getDbConfig(), tableInfo, field));
        }
        tableInfo.setFieldList(fieldList);
        if (StringUtils.isEmpty((CharSequence)tableInfo.getKeyColumn())) {
            logger.warn(String.format("Warn: Could not find @TableId in Class: %s.", clazz.getName()));
        }
    }

    static List<Field> getAllFields(Class<?> clazz) {
        List fieldList = ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz));
        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
            return fieldList.stream().filter(i -> {
                TableField tableField = i.getAnnotation(TableField.class);
                return tableField == null || tableField.exist();
            }).collect(Collectors.toList());
        }
        return fieldList;
    }

    static boolean isExistTableId(List<Field> list) {
        for (Field field : list) {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId == null) continue;
            return true;
        }
        return false;
    }

    private static boolean initTableIdWithAnnotation(TableInfo tableInfo, Field field, Class<?> clazz) {
        TableId tableId = field.getAnnotation(TableId.class);
        boolean underCamel = true;
        if (tableId != null && StringUtils.isEmpty((CharSequence)tableInfo.getKeyColumn())) {
            String column = field.getName();
            if (StringUtils.isNotEmpty((CharSequence)tableId.value())) {
                column = tableId.value();
            } else if (underCamel) {
                column = StringUtils.camelToUnderline((String)column);
            }
            tableInfo.setClazz(field.getDeclaringClass()).setKeyColumn(column).setKeyProperty(field.getName());
            return true;
        }
        return false;
    }

    private static boolean initTableIdWithoutAnnotation(TableInfo tableInfo, Field field, Class<?> clazz) {
        String column = field.getName();
        if ("id".equalsIgnoreCase(column) && StringUtils.isEmpty((CharSequence)tableInfo.getKeyColumn())) {
            tableInfo.setKeyColumn(column).setKeyProperty(field.getName()).setClazz(field.getDeclaringClass());
            return true;
        }
        return false;
    }

    private static boolean initTableFieldWithAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, List<TableFieldInfo> fieldList, Field field, Class<?> clazz) {
        String[] els;
        String[] columns;
        TableField tableField = field.getAnnotation(TableField.class);
        if (null == tableField) {
            return false;
        }
        String columnName = field.getName();
        if (StringUtils.isNotEmpty((CharSequence)tableField.value())) {
            columnName = tableField.value();
        }
        String el = field.getName();
        if (StringUtils.isNotEmpty((CharSequence)tableField.el())) {
            el = tableField.el();
        }
        if ((columns = columnName.split(";")).length == (els = el.split(";")).length) {
            for (int i = 0; i < columns.length; ++i) {
                fieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, columns[i], els[i], tableField));
            }
            return true;
        }
        return false;
    }
}

