/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.framework.skeleton.template.es.EsEntity;
import com.ejianc.framework.skeleton.template.es.IBaseEsQueryDao;
import com.ejianc.framework.skeleton.template.es.TableInfoTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public class BaseServiceImpl<M extends BaseCrudMapper<T>, T>
extends ServiceImpl<M, T>
implements IBaseService<T> {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private IBaseEsQueryDao<T> baseEsQueryDao;
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Override
    @Transactional
    public boolean saveOrUpdate(T entity, boolean syncEs) {
        boolean isSuccess = super.saveOrUpdate(entity);
        if (isSuccess && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("insertOrUpdateOne");
            esEntity.setContent(JSON.toJSONString(entity));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean saveOrUpdateBatch(List<T> entityList, int batchSize, boolean syncEs) {
        boolean isSuccess = super.saveOrUpdateBatch(entityList, batchSize);
        if (isSuccess && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(entityList.get(0).getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("insertOrUpdateBatch");
            esEntity.setContent(JSON.toJSONString(entityList));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean removeById(Serializable id, boolean syncEs) {
        boolean isSuccess = false;
        Object bean = super.getById(id);
        if (bean != null && (isSuccess = super.removeById(id)) && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(bean.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("deleteById");
            esEntity.setContent(id.toString());
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean removeByMap(Map<String, Object> columnMap, boolean syncEs) {
        boolean isSuccess = false;
        Collection list = super.listByMap(columnMap);
        if (list != null && list.size() > 0 && (isSuccess = super.removeByMap(columnMap)) && syncEs) {
            Object tableBean = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object bean : list) {
                tableBean = bean;
                BaseEntity baseEntity = (BaseEntity)bean;
                ids.add(baseEntity.getId());
            }
            TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("deleteBatch");
            esEntity.setContent(JSON.toJSONString(ids));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean remove(Wrapper<T> wrapper, boolean syncEs) {
        boolean isSuccess = false;
        List list = super.list(wrapper);
        if (list != null && list.size() > 0 && (isSuccess = super.remove(wrapper)) && syncEs) {
            Object tableBean = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object bean : list) {
                tableBean = bean;
                BaseEntity baseEntity = (BaseEntity)bean;
                ids.add(baseEntity.getId());
            }
            TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("deleteBatch");
            esEntity.setContent(JSON.toJSONString(ids));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList, boolean syncEs) {
        boolean isSuccess = false;
        Collection list = super.listByIds(idList);
        if (list != null && list.size() > 0 && (isSuccess = super.removeByIds(idList)) && syncEs) {
            Object tableBean = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object bean : list) {
                tableBean = bean;
                BaseEntity baseEntity = (BaseEntity)bean;
                ids.add(baseEntity.getId());
            }
            TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("deleteBatch");
            esEntity.setContent(JSON.toJSONString(ids));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean update(T entity, Wrapper<T> updateWrapper, boolean syncEs) {
        boolean isSuccess = super.update(entity, updateWrapper);
        if (isSuccess && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("insertOrUpdateOne");
            esEntity.setContent(JSON.toJSONString(entity));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public List<T> queryList(QueryParam queryParam, boolean isEs) {
        List<Object> list = new ArrayList();
        if (isEs) {
            list = this.baseEsQueryDao.selectList(queryParam);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            Map params = queryParam.getParams();
            for (Map.Entry entry : params.entrySet()) {
                String type;
                Parameter param = (Parameter)entry.getValue();
                switch (type = param.getType()) {
                    case "eq": {
                        queryWrapper.eq((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "ne": {
                        queryWrapper.ne((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "in": {
                        if (param.getValue() instanceof List) {
                            queryWrapper.in((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), (Collection)((List)param.getValue()));
                            break;
                        }
                        if (!(param.getValue() instanceof String)) break;
                        String[] paramArr = param.getValue().toString().split(",");
                        queryWrapper.in((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), (Object[])paramArr);
                        break;
                    }
                    case "not_in": {
                        if (param.getValue() instanceof List) {
                            queryWrapper.notIn((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), (Collection)((List)param.getValue()));
                            break;
                        }
                        if (!(param.getValue() instanceof String)) break;
                        String[] paramArr = param.getValue().toString().split(",");
                        queryWrapper.notIn((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), (Object[])paramArr);
                        break;
                    }
                    case "like": {
                        if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                        queryWrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "not_like": {
                        if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                        queryWrapper.notLike((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "like_left": {
                        if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                        queryWrapper.notLike((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "like_right": {
                        if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                        queryWrapper.notLike((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                    }
                }
            }
            Map orderMap = queryParam.getOrderMap();
            for (String key : orderMap.keySet()) {
                String value = (String)orderMap.get(key);
                if ("asc".equals(value.toLowerCase())) {
                    queryWrapper.orderByAsc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
                    continue;
                }
                if (!"desc".equals(value.toLowerCase())) continue;
                queryWrapper.orderByDesc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
            }
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public IPage<T> queryPage(QueryParam queryParam, boolean isEs) {
        IPage page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        if (isEs) {
            page = this.baseEsQueryDao.selectPage(page, queryParam);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            Map params = queryParam.getParams();
            for (Map.Entry entry : params.entrySet()) {
                String type;
                Parameter param = (Parameter)entry.getValue();
                switch (type = param.getType()) {
                    case "eq": {
                        queryWrapper.eq((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "ne": {
                        queryWrapper.ne((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "in": {
                        if (param.getValue() instanceof List) {
                            queryWrapper.in((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), (Collection)((List)param.getValue()));
                            break;
                        }
                        if (!(param.getValue() instanceof String)) break;
                        String[] paramArr = param.getValue().toString().split(",");
                        queryWrapper.in((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), (Object[])paramArr);
                        break;
                    }
                    case "not_in": {
                        if (param.getValue() instanceof List) {
                            queryWrapper.notIn((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), (Collection)((List)param.getValue()));
                            break;
                        }
                        if (!(param.getValue() instanceof String)) break;
                        String[] paramArr = param.getValue().toString().split(",");
                        queryWrapper.notIn((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), (Object[])paramArr);
                        break;
                    }
                    case "like": {
                        if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                        queryWrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "not_like": {
                        if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                        queryWrapper.notLike((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "like_left": {
                        if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                        queryWrapper.notLike((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                        break;
                    }
                    case "like_right": {
                        if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                        queryWrapper.notLike((Object)CamelAndUnderLineConverter.humpToLine((String)((String)entry.getKey())), param.getValue());
                    }
                }
            }
            Map orderMap = queryParam.getOrderMap();
            for (String key : orderMap.keySet()) {
                String value = (String)orderMap.get(key);
                if ("asc".equals(value.toLowerCase())) {
                    queryWrapper.orderByAsc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
                    continue;
                }
                if (!"desc".equals(value.toLowerCase())) continue;
                queryWrapper.orderByDesc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
            }
            page = this.page(page, (Wrapper)queryWrapper);
        }
        return page;
    }
}

