/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.billState.controller;

import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"common/business"})
public class CommonBusinessController {
    @Autowired
    private IMdClassApi mdClassApi;

    public static String toLowerCaseFirstOne(String param) {
        if (Character.isLowerCase(param.charAt(0))) {
            return param;
        }
        return Character.toLowerCase(param.charAt(0)) + param.substring(1);
    }

    private ICommonBusinessService obtainBusinessService(CommonBusinessParam businessParam) {
        CommonResponse mdClassResponse = this.mdClassApi.queryDetail(businessParam.getMetadataId());
        if (mdClassResponse.isSuccess()) {
            MdClassVO mdClassVo = (MdClassVO)mdClassResponse.getData();
            String serviceName = CommonBusinessController.toLowerCaseFirstOne(mdClassVo.getEntityName().replace("Entity", ""));
            ICommonBusinessService businessService = null;
            try {
                businessService = ContextUtil.getBean(serviceName, ICommonBusinessService.class);
            }
            catch (Exception e) {
                businessService = ContextUtil.getBean("defaultBusinessService", ICommonBusinessService.class);
            }
            return businessService;
        }
        return null;
    }

    @RequestMapping(value={"beforeSubmit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> beforeSubmitProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeSubmitProcessor(businessParam.getBillId(), businessParam.getBillState());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"afterSubmit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> afterSubmitProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeSubmitProcessor(businessParam.getBillId(), businessParam.getBillState());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"beforeApproval"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> beforeApprovalProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeApprovalProcessor(businessParam.getBillId(), businessParam.getBillState());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"afterApproval"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> afterApprovalProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeApprovalProcessor(businessParam.getBillId(), businessParam.getBillState());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"beforeAbstaining"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> beforeAbstainingProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeApprovalProcessor(businessParam.getBillId(), businessParam.getBillState());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    @RequestMapping(value={"afterAbstaining"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> afterAbstainingProcessor(@RequestBody CommonBusinessParam businessParam) {
        ICommonBusinessService businessService = this.obtainBusinessService(businessParam);
        if (businessService != null) {
            return businessService.beforeApprovalProcessor(businessParam.getBillId(), businessParam.getBillState());
        }
        return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }
}

