/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.refer.util;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ReferHttpClientUtils {
    public static final int connTimeout = 10000;
    public static final int readTimeout = 10000;
    public static final String charset = "UTF-8";
    private static HttpClient client = null;

    public static String postParameters(String url, String parameterStr) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        return ReferHttpClientUtils.post(url, parameterStr, "application/x-www-form-urlencoded", charset, 10000, 10000);
    }

    public static String postParameters(String url, String parameterStr, String charset, Integer connTimeout, Integer readTimeout) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        return ReferHttpClientUtils.post(url, parameterStr, "application/x-www-form-urlencoded", charset, connTimeout, readTimeout);
    }

    public static String postByJson(String url, String parameterStr) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        return ReferHttpClientUtils.post(url, parameterStr, "application/json", charset, 10000, 10000);
    }

    public static String postParameters(String url, Map<String, String> params) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        return ReferHttpClientUtils.postForm(url, params, null, null, 10000, 10000);
    }

    public static String postFormByJson(String url, Map<String, String> params, Map<String, String> headers) throws ClientProtocolException, GeneralSecurityException, IOException {
        return ReferHttpClientUtils.postForm(url, params, headers, "application/json", 10000, 10000);
    }

    public static String postParameters(String url, Map<String, String> params, Integer connTimeout, Integer readTimeout) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        return ReferHttpClientUtils.postForm(url, params, null, "application/json", connTimeout, readTimeout);
    }

    public static String get(String url, HttpServletRequest req) throws ClientProtocolException, GeneralSecurityException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", req.getHeader("authority"));
        headers.put("ejc-token", req.getHeader("ejc-token"));
        return ReferHttpClientUtils.get(url, null, headers);
    }

    public static String get(String url, Map<String, ?> params, HttpServletRequest req) throws ClientProtocolException, GeneralSecurityException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", req.getHeader("authority"));
        headers.put("ejc-token", req.getHeader("ejc-token"));
        return ReferHttpClientUtils.get(url, params, headers);
    }

    public static String get(String url, Map<String, ?> params, Map<String, String> headers) throws ClientProtocolException, GeneralSecurityException, IOException {
        return ReferHttpClientUtils.get(url, charset, 10000, 10000, params, headers);
    }

    public static String getAndHeader(String url, Map<String, ?> params) throws ClientProtocolException, GeneralSecurityException, IOException {
        return ReferHttpClientUtils.get(url, charset, 10000, 10000, params, ReferHttpClientUtils.getHeaders());
    }

    public static Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            headers = new HashMap();
            if (request.getHeader("authority") != null) {
                headers.put("authority", request.getHeader("authority"));
            }
            if (request.getHeader("ejc-token") != null) {
                headers.put("ejc-token", request.getHeader("ejc-token"));
            }
            if (request.getHeader("ejc-user") != null) {
                headers.put("ejc-user", request.getHeader("ejc-user"));
            }
        } else {
            if (InvocationInfoProxy.getParameter((String)"authority") != null) {
                headers.put("authority", InvocationInfoProxy.getParameter((String)"authority").toString());
            }
            if (InvocationInfoProxy.getParameter((String)"ejc-token") != null) {
                headers.put("ejc-token", InvocationInfoProxy.getParameter((String)"ejc-token").toString());
            }
            if (InvocationInfoProxy.getParameter((String)"ejc-user") != null) {
                headers.put("ejc-user", InvocationInfoProxy.getParameter((String)"ejc-user").toString());
            }
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String body, String mimeType, String charset, Integer connTimeout, Integer readTimeout) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String result = "";
        try {
            HttpResponse res;
            if (StringUtils.isNotBlank((String)body)) {
                StringEntity entity = new StringEntity(body, ContentType.create((String)mimeType, (String)charset));
                post.setEntity((HttpEntity)entity);
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            post.addHeader("authority", request.getHeader("authority"));
            post.addHeader("ejc-token", request.getHeader("ejc-token"));
            if (url.startsWith("https")) {
                client = ReferHttpClientUtils.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                client = ReferHttpClientUtils.client;
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String postForm(String url, Map<String, String> params, Map<String, String> headers, String contentType, Integer connTimeout, Integer readTimeout) throws GeneralSecurityException, ClientProtocolException, IOException {
        HttpPost post;
        CloseableHttpClient client;
        block16: {
            void var9_15;
            block15: {
                String string;
                client = null;
                post = new HttpPost(url);
                try {
                    if (params != null && !params.isEmpty()) {
                        ArrayList formParams = new ArrayList();
                        Set<Map.Entry<String, String>> set = params.entrySet();
                        for (Map.Entry<String, String> entry : set) {
                            formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                        }
                        UrlEncodedFormEntity entity = new UrlEncodedFormEntity((Iterable)formParams, Consts.UTF_8);
                        if (contentType != null) {
                            entity.setContentType(contentType);
                        }
                        post.setEntity((HttpEntity)entity);
                    }
                    if (headers != null && !headers.isEmpty()) {
                        for (Map.Entry entry : headers.entrySet()) {
                            post.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    RequestConfig.Builder customReqConf = RequestConfig.custom();
                    if (connTimeout != null) {
                        customReqConf.setConnectTimeout(connTimeout.intValue());
                    }
                    if (readTimeout != null) {
                        customReqConf.setSocketTimeout(readTimeout.intValue());
                    }
                    post.setConfig(customReqConf.build());
                    Object var9_12 = null;
                    if (url.startsWith("https")) {
                        client = ReferHttpClientUtils.createSSLInsecureClient();
                        HttpResponse httpResponse = client.execute((HttpUriRequest)post);
                    } else {
                        client = ReferHttpClientUtils.client;
                        HttpResponse httpResponse = client.execute((HttpUriRequest)post);
                    }
                    if (var9_15.getStatusLine().getStatusCode() != 200) break block15;
                    string = IOUtils.toString((InputStream)var9_15.getEntity().getContent(), (String)charset);
                }
                catch (Throwable throwable) {
                    post.releaseConnection();
                    if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                        ((CloseableHttpClient)client).close();
                    }
                    throw throwable;
                }
                post.releaseConnection();
                if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                    client.close();
                }
                return string;
            }
            if (var9_15.getStatusLine().getStatusCode() != 404) break block16;
            throw new BusinessException("404, \u4e0d\u80fd\u8fde\u63a5\u5230\u76ee\u6807\u670d\u52a1\u5668!");
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String get(String url, String charset2, Integer conntimeout, Integer readtimeout, Map<String, ?> params, Map<String, String> headers) throws IllegalStateException, IOException, GeneralSecurityException {
        CloseableHttpClient client = null;
        if (params != null && params.size() > 0) {
            String[] paramsArray = params.keySet().toArray(new String[0]);
            for (int i = 0; i < paramsArray.length; ++i) {
                if (params.get(paramsArray[i]) == null) continue;
                url = url + (i == 0 ? "?" : "&") + paramsArray[i] + "=" + URLEncoder.encode(params.get(paramsArray[i]).toString(), "utf-8");
            }
        }
        HttpGet get = new HttpGet(url);
        String result = "";
        try {
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (conntimeout != null) {
                customReqConf.setConnectTimeout(10000);
            }
            if (readtimeout != null) {
                customReqConf.setSocketTimeout(10000);
            }
            get.setConfig(customReqConf.build());
            if (headers.containsKey("authority")) {
                get.addHeader("authority", headers.get("authority"));
            }
            if (headers.containsKey("ejc-token")) {
                get.addHeader("ejc-token", headers.get("ejc-token"));
            }
            HttpResponse res = null;
            if (url.startsWith("https")) {
                client = ReferHttpClientUtils.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)get);
            } else {
                client = ReferHttpClientUtils.client;
                res = client.execute((HttpUriRequest)get);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Throwable throwable) {
            get.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        get.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    private static String getCharsetFromResponse(HttpResponse ressponse) {
        String contentType;
        if (ressponse.getEntity() != null && ressponse.getEntity().getContentType() != null && ressponse.getEntity().getContentType().getValue() != null && (contentType = ressponse.getEntity().getContentType().getValue()).contains("charset=")) {
            return contentType.substring(contentType.indexOf("charset=") + 8);
        }
        return null;
    }

    public static CloseableHttpClient createSSLInsecureClient() throws GeneralSecurityException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }
        });
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    public static void main(String[] args) {
        try {
            String str = ReferHttpClientUtils.post("https://localhost:443/ssl/test.shtml", "name=12&page=34", "application/x-www-form-urlencoded", charset, 10000, 10000);
            System.out.println(str);
        }
        catch (ConnectTimeoutException e) {
            e.printStackTrace();
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(128);
        cm.setDefaultMaxPerRoute(128);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

