/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.refer.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.ClientProtocolException;
import org.springframework.data.redis.core.RedisTemplate;

public class ReferObjectUtil {
    private static final String REFER_CACHE_KEY = "refer_cache_key:";

    public static JSONObject getReferEntityValue(Long valueId, String referCode) throws Exception {
        MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
        JSONObject jsonObj = null;
        String cacheKey = REFER_CACHE_KEY + referCode + ":" + valueId;
        RedisTemplate redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
        Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
        if (cacheValue != null) {
            jsonObj = JSON.parseObject((String)cacheValue.toString());
        } else {
            String referData = ReferObjectUtil.getReferRestUrl(referCode);
            JSONObject json = JSON.parseObject((String)referData);
            String referUrl = json.get((Object)"projectName").toString();
            Map<String, Object> reflist = new HashMap();
            reflist = (Map)json.get((Object)"refMapList");
            reflist.put("valueId", valueId);
            reflist.put("databaseName", json.get((Object)"databaseName"));
            reflist.put("tableName", json.get((Object)"tableName"));
            String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getrefervalue";
            String jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
            jsonObj = JSON.parseObject((String)jsonbackstr);
            redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 5L, TimeUnit.MINUTES);
        }
        return jsonObj;
    }

    private static String getReferRestUrl(String referCode) {
        String data = null;
        MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
        }
        catch (ClientProtocolException e) {
            ExceptionUtil.wrappException((Exception)((Object)e));
        }
        catch (GeneralSecurityException e) {
            ExceptionUtil.wrappException(e);
        }
        catch (IOException e) {
            ExceptionUtil.wrappException(e);
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject((String)jsonobject.getString("data")).toJSONString();
            }
        } else {
            ExceptionUtil.wrappBusinessException("\u53c2\u7167\u7f16\u7801" + referCode + "\u7684\u5b9e\u4f53\u6ca1\u6709\u53d1\u5e03\u5143\u6570\u636e!");
        }
        return data;
    }
}

