package com.ejianc.framework.skeleton;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.injector.LogicSqlInjector;
import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PerformanceInterceptor;

@Configuration
public class MybatisPlusConfig {
	/**
	 * 分页插件
	 */
	@Bean
	@ConditionalOnMissingBean(value= {PaginationInterceptor.class})
	public PaginationInterceptor paginationInterceptor() {
		return new PaginationInterceptor();
	}

	/**
	 * sql注入器 逻辑删除插件
	 * 
	 * @return
	 */
	@Bean
	@ConditionalOnMissingBean(value= {ISqlInjector.class})
	public ISqlInjector iSqlInjector() {
		return new LogicSqlInjector();
	}

	/**
	 * sql性能分析插件，输出sql语句及所需时间
	 * 
	 * @return
	 */
	@Bean
	@Profile({ "dev", "test" }) // 设置 dev test 环境开启
	public PerformanceInterceptor performanceInterceptor() {
		return new PerformanceInterceptor();
	}
	
	@Bean
	public OptimisticLockerInterceptor optimisticLockerInterceptor() {
	    return new OptimisticLockerInterceptor();
	}
	
	
}