package com.ejianc.framework.skeleton.billState.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;

/**
 * 流程中心事件回调
 * 
 * @author guoming
 */
@Controller
@RequestMapping(value = "common/business")
public class CommonBusinessController {

	@Autowired
	private IMdClassApi mdClassApi;

	public static String toLowerCaseFirstOne(String param) {
		if (Character.isLowerCase(param.charAt(0))) {
			return param;
		} else {
			return (new StringBuilder()).append(Character.toLowerCase(param.charAt(0))).append(param.substring(1)).toString();
		}
	}
	
	private ICommonBusinessService obtainBusinessService(CommonBusinessParam businessParam) {
		CommonResponse<MdClassVO> mdClassResponse = mdClassApi.queryDetail(businessParam.getMetadataId());
		if (mdClassResponse.isSuccess()) {
			MdClassVO mdClassVo = mdClassResponse.getData();
			String serviceName = toLowerCaseFirstOne(mdClassVo.getEntityName().replace("Entity", ""));
			ICommonBusinessService businessService = null;
			try{
				businessService = ContextUtil.getBean(serviceName, ICommonBusinessService.class);
			}catch (Exception e){
				businessService = ContextUtil.getBean("defaultBusinessService", ICommonBusinessService.class);
			}
			return businessService;
		}
		return null;
	}

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "beforeSubmit", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> beforeSubmitProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.beforeSubmitProcessor(businessParam.getBillId(), businessParam.getBillState());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "afterSubmit", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> afterSubmitProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.afterSubmitProcessor(businessParam.getBillId(), businessParam.getBillState());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "beforeApproval", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> beforeApprovalProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.beforeApprovalProcessor(businessParam.getBillId(), businessParam.getBillState());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "afterApproval", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> afterApprovalProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.afterApprovalProcessor(businessParam.getBillId(), businessParam.getBillState());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "beforeAbstaining", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> beforeAbstainingProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.beforeApprovalProcessor(businessParam.getBillId(), businessParam.getBillState());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@RequestMapping(value = "afterAbstaining", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> afterAbstainingProcessor(@RequestBody CommonBusinessParam businessParam) {
		ICommonBusinessService businessService = obtainBusinessService(businessParam);
		if(businessService != null) {
			return businessService.afterApprovalProcessor(businessParam.getBillId(), businessParam.getBillState());
		}
		return CommonResponse.error("网络异常，请稍后重试！");
	}

}
