package com.ejianc.framework.skeleton;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.support.idworker.api.IKeyGeneratorApi;

/**
 * Title: MetaHandler Description: 自动填充公共字段
 * 
 * @author guominga
 * @date 2019年3月5日
 */
@Component
@ConfigurationProperties
public class MetaHandler implements MetaObjectHandler {
	
	@Autowired(required = false)
	private IKeyGeneratorApi keyGeneratorApi;
	
	@Autowired(required = false)
	private IAttachmentApi attachmentApi;
	
	/*
	 * <p>Title: insertFill</p> <p>Description: </p>
	 * 
	 * @param metaObject
	 */
	@Override
	@SuppressWarnings("unchecked")
	public void insertFill(MetaObject object) {
		Object primaryKey = getFieldValByName("id", object);
		Long pkId  = 0l;
		if(primaryKey == null) {
			pkId = keyGeneratorApi.generateKey();
			setFieldValByName("id", pkId, object);
		}else{
			pkId = Long.parseLong(primaryKey + "");
		}
		Object attachObject = getFieldValByName("attachIds", object);
		if(attachObject != null){
			List<Long> attachIds = (List<Long>) attachObject;
			attachmentApi.updateAttachRef(pkId, attachIds);
		}
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(tenantId != null) {
			setFieldValByName("tenantId", tenantId, object);
		}
		String userCode = InvocationInfoProxy.getUsercode();
		if((null == getFieldValByName("createUserCode", object)) && StringUtils.isNotBlank(userCode)) {
			setFieldValByName("createUserCode", userCode, object);
		}
		if(null == getFieldValByName("createTime", object)) {
			setFieldValByName("createTime", new Date(), object);
		}

		setFieldValByName("dr", 0, object);
		setFieldValByName("syncEsFlag", 0, object);
		setFieldValByName("billState", 0, object);
		setFieldValByName("version", 1, object);
	}

	/*
	 * <p>Title: updateFill</p> <p>Description: </p>
	 * 
	 * @param metaObject
	 */
	@Override
	public void updateFill(MetaObject object) {
		String userCode = InvocationInfoProxy.getUsercode();
		if(StringUtils.isNotBlank(userCode)) {
			setFieldValByName("updateUserCode", userCode, object);
		}
		setFieldValByName("updateTime", new Date(), object);
		setFieldValByName("syncEsFlag", 0, object);
	}
}
