package com.ejianc.framework.skeleton.mq.customer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import com.ejianc.framework.skeleton.template.es.EsEntity;
import com.ejianc.framework.skeleton.template.es.IBaseEsCudDao;

/**  
  * 业务数据同步es的mq消费
  * 
  * @author guominga  
  * @date 2020年2月14日  
  */
@Component
public class BusinessDataCustomer extends BaseConsumer {

	@Value("${spring.application.name}")
	private String message_queue_name;
	
	@Autowired
	private IBaseEsCudDao baseEsCudDao;
	
	@Override
	protected void doConsumeMsg(MqMessage mqMessage) {
		EsEntity esEntity = (EsEntity) mqMessage.getBody();
		if(esEntity != null) {
			String type = esEntity.getType();
			switch(type) {
				case "insertOrUpdateOne":
					baseEsCudDao.insertOrUpdateOne(esEntity.getIndexName(), esEntity);
					break;
				case "insertOrUpdateBatch":
					baseEsCudDao.insertOrUpdateBatch(esEntity.getIndexName(), esEntity);
					break;
				case "deleteBatch":
					baseEsCudDao.deleteBatch(esEntity.getIndexName(), esEntity);
					break;
				case "deleteById":
					baseEsCudDao.deleteById(esEntity.getIndexName(), esEntity);
					break;
			}
			
		}
	}

	@Override
	protected String[] getQueueNames() {
		return new String[]{message_queue_name};
	}




}
