package com.ejianc.framework.skeleton.template;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 业务service的基类
 * 
 * @author guominga
 * @date 2020年2月16日
 */
public interface IBaseService<T> extends IService<T> {
	
	/**
	 * 增加或修改对象
	 * 
	 * @param entity 实体对象
	 * @param syncEs 是否同步es
	 */
	public boolean saveOrUpdate(T entity, boolean syncEs);
	
	/**
	 * 批量增加或修改对象
	 * 
	 * @param entityList 实体对象list
	 * @param batchSize 一次批量增加或修改对象数量
	 * @param syncEs 是否同步es
	 */
	public boolean saveOrUpdateBatch(List<T> entityList, int batchSize, boolean syncEs);
	
	/**
	 * 根据主键ID查询对象
	 * 
	 * @param id 主键id
	 */
	public T selectById(Serializable id);

	/**
	 * 根据主键ID删除对象
	 *
	 * @param id 主键id
	 * @param syncEs 是否同步es
	 */
	public boolean removeById(Serializable id, boolean syncEs);

	/**
	 * 根据map删除对象
	 * 
	 * @param columnMap 参数map
	 * @param syncEs 是否同步es
	 */
	public boolean removeByMap(Map<String, Object> columnMap, boolean syncEs);
	
	/**
	 * 根据wrapper条件删除对象
	 * 
	 * @param wrapper 参数条件
	 * @param syncEs 是否同步es
	 */
	public boolean remove(Wrapper<T> wrapper, boolean syncEs);

	/**
	 * 根据主键Idlist删除满足条件的对象
	 * 
	 * @param idList 参数条件
	 * @param syncEs 是否同步es
	 */
	public boolean removeByIds(Collection<? extends Serializable> idList, boolean syncEs);
	
	/**
	 * 根据wrapper修改对象
	 * 
	 * @param entity 实体对象
	 * @param updateWrapper 条件
	 * @param syncEs 是否同步es
	 */
	public boolean update(T entity, Wrapper<T> updateWrapper, boolean syncEs);
	
	/**
	 * 根据查询对象查询list
	 * 
	 * @param queryParam 查询参数
	 * @param isEs 是否查询es
	 * @return
	 */
	public List<T> queryList(QueryParam queryParam, boolean isEs);
	
	/**
	 * 查询分页对象
	 * 
	 * @param queryParam 查询参数
	 * @param isEs 是否查询es
	 * @return
	 */
	public IPage<T> queryPage(QueryParam queryParam, boolean isEs);
}
