package com.ejianc.framework.skeleton.fields.controller;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;

/**  
  * QueryFields公共服务
  * 
  * @author liyongjia  
  * @date 2020年5月28日  
  */
@Controller
@RequestMapping(value = "commonFields")
public class CommenQueryFieldsController {
	private final static org.slf4j.Logger logger = LoggerFactory.getLogger(CommenQueryFieldsController.class);

	@Autowired
	private ICommenQueryFieldsService commenQueryFieldsService;
	/**
	 * 
	 * 根据数据表查询该表中对应的字段
	 * 
	 **/
	@RequestMapping(value = "queryFieldsByTableName", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<MdAttributeVO>> queryFieldsByTableName(@RequestParam String tableName,@RequestParam String databaseName) {
		if(StringUtils.isBlank(tableName)) {
			logger.error("数据库表不能为空！");
			return CommonResponse.error("数据库表不能为空");
		}
		List<MdAttributeVO> result =  commenQueryFieldsService.queryFieldsByTableName(tableName,databaseName);
		return CommonResponse.success(result);
	}
}
