package com.ejianc.framework.skeleton.billState.service;

import com.ejianc.framework.core.response.CommonResponse;

public interface ICommonBusinessService {

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	public default CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	public default CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

}
