package com.ejianc.framework.skeleton.fields.service;

import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.skeleton.fields.controller.param.CostParameter;

public interface ICommenQueryFieldsService {

	List<MdAttributeVO> queryFieldsByTableName(String tableName, String databaseName);

	//根据单据类型code与单据id查询单据详情
	JSONObject queryBillDetail(String businessKey, String billTypeCode);

	JSONArray queryBillInfoByProperty(String databaseName, String tableName, String columns, String parameter);
	
	
	/**
	 * 成本来源配置使用
	 * 
	 * @param billTypeCode 单据类型编号
	 * @param parameter 参数
	 * @param condition  条件
	 * @return
	 */
	List<JSONObject> queryBillList(String billTypeCode, String parameter, String condition);

	/**
	 * 查询成本数据
	 * 
	 * @param costParameter
	 * @return
	 */
	List<JSONObject> queryCostDatas(CostParameter costParameter);
	
	
	/**
	 * 修改业务表中： proportion_flag  分摊状态(1:是，0：否)
	 * 
	 * @param billTypeCode
	 * @param billId
	 * @return
	 */
	boolean updateProportionFlag(String billTypeCode, String billId, String proportionFlag);

	/**
	 * 修改数据库
	 * 
	 * @param jsonObject
	 */
	void updateProportionFlagDb(JSONObject jsonObject);
}
