package com.ejianc.framework.skeleton.fields.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.controller.param.CostParameter;
import com.ejianc.framework.skeleton.fields.mapper.CommenQueryFieldsMapper;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@Service
public class CommenQueryFieldsService implements ICommenQueryFieldsService {
	// 日志
	private final Logger logger = LoggerFactory.getLogger(getClass());

	private Gson gson = new Gson();

	@Value("${common.env.base-host}")
	private String baseHost;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private CommenQueryFieldsMapper commenQueryFieldsMapper;
	
	@Override
	public List<MdAttributeVO> queryFieldsByTableName(String tableName, String databaseName) {
		List<MdAttributeVO> list = commenQueryFieldsMapper.queryFieldsByTableName(tableName, databaseName);
		return list;
	}

	@Override
	public JSONObject queryBillDetail(String businessKey, String billTypeCode) {
		CommonResponse<MdReferVO> billTypeResponse = billTypeApi.queryMetadataByBillType(billTypeCode);
		if(billTypeResponse.isSuccess()) {
			MdReferVO referVo = billTypeResponse.getData();
			Map<String, String> paramterMap = new HashMap<>();
			paramterMap.put("billId", String.valueOf(businessKey));
			paramterMap.put("tableName", referVo.getTableName());
			paramterMap.put("metadataId", referVo.getMetadataId().toString());

			logger.info("修改单据状态传递的参数：---------------"+paramterMap.toString());
			String paramterStr = gson.toJson(paramterMap);
			String url = baseHost + referVo.getProjectName() + "/commonstate/queryBillDetail";
			logger.info("修改单据状态传递的url：---------------"+url);
			try {
				String result = ReferHttpClientUtils.postByJson(url, paramterStr);
				logger.info("修改单据状态返回的结果：---------------"+result);
				return gson.fromJson(result, new TypeToken<JSONObject>() {}.getType());
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	@Override
	public JSONArray queryBillInfoByProperty(String databaseName, String tableName, String columns, String parameter) {
		return commenQueryFieldsMapper.queryBillInfoByProperty(databaseName, tableName, columns, parameter);
	}

	@Override
	public List<JSONObject> queryBillList(String billTypeCode, String parameter, String condition) {
		CommonResponse<MdReferVO> billTypeResponse = billTypeApi.queryMetadataByBillType(billTypeCode);
		if(billTypeResponse.isSuccess()) {
			MdReferVO referVo = billTypeResponse.getData();
			Map<String, String> paramterMap = new HashMap<>();
			paramterMap.put("parameter", parameter);
			paramterMap.put("tableName", referVo.getTableName());
			paramterMap.put("condition", condition);
			String paramterStr = gson.toJson(paramterMap);
			String url = baseHost + referVo.getProjectName() + "/common/queryCostDatas";
			try {
				String result = ReferHttpClientUtils.postByJson(url, paramterStr);
				CommonResponse<List<JSONObject>> commonResponse =  gson.fromJson(result, new TypeToken<CommonResponse<List<JSONObject>>>() {}.getType());
				if(commonResponse.isSuccess()) {
					return commonResponse.getData();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	@Override
	public List<JSONObject> queryCostDatas(CostParameter costParameter) {
		List<JSONObject> costDatas = commenQueryFieldsMapper.queryCostDatas(costParameter.getParameter(),costParameter.getTableName(),costParameter.getCondition());
		return costDatas;
	}

	@Override
	public boolean updateProportionFlag(String billTypeCode, String billId, String proportionFlag) {
		CommonResponse<MdReferVO> billTypeResponse = billTypeApi.queryMetadataByBillType(billTypeCode);
		if(billTypeResponse.isSuccess()) {
			MdReferVO referVo = billTypeResponse.getData();
			Map<String, String> paramterMap = new HashMap<>();
			paramterMap.put("billId", billId);
			paramterMap.put("tableName", referVo.getTableName());
			paramterMap.put("proportionFlag", proportionFlag);
			String paramterStr = gson.toJson(paramterMap);
			String url = baseHost + referVo.getProjectName() + "/common/updateProportionFlag";
			try {
				String result = ReferHttpClientUtils.postByJson(url, paramterStr);
				CommonResponse<String> commonResponse = gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
				if(commonResponse.isSuccess()) {
					return true;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return false;
	}

	@Override
	public void updateProportionFlagDb(JSONObject jsonObject) {
		commenQueryFieldsMapper.updateProportionFlag(jsonObject.getString("billId"), jsonObject.getString("tableName"), jsonObject.getString("proportionFlag"));
	}

}
