package com.ejianc.framework.skeleton.filter;

import javax.servlet.Filter;

import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**  
  * Title: AccessControlConfig  
  * Description: 
  * @author guominga  
  * @date 2019年3月8日  
  */
@Configuration
public class AccessControlConfiguration {

	@Bean("accessControlFilter")
	public FilterRegistrationBean<Filter> buildSingleSignOutFilter() {
		FilterRegistrationBean<Filter> filterRegistrationBean = new FilterRegistrationBean<>();
		filterRegistrationBean.setOrder(1);
		filterRegistrationBean.setFilter(new AccessControlFilter());
		filterRegistrationBean.setName("accessControlFilter");
		filterRegistrationBean.addUrlPatterns("/*");
		return filterRegistrationBean;
	}
	
}
