/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.fields.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.controller.param.CostParameter;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"commonFields"})
public class CommenQueryFieldsController {
    private static final Logger logger = LoggerFactory.getLogger(CommenQueryFieldsController.class);
    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    @RequestMapping(value={"queryFieldsByTableName"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MdAttributeVO>> queryFieldsByTableName(@RequestParam String tableName, @RequestParam String databaseName) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            logger.error("\u6570\u636e\u5e93\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return CommonResponse.error((String)"\u6570\u636e\u5e93\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<MdAttributeVO> result = this.commenQueryFieldsService.queryFieldsByTableName(tableName, databaseName);
        return CommonResponse.success(result);
    }

    @RequestMapping(value={"queryCostDatas"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryCostDatas(@RequestBody CostParameter costParameter) {
        if (StringUtils.isBlank((CharSequence)costParameter.getParameter())) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)costParameter.getTableName())) {
            return CommonResponse.error((String)"\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)costParameter.getCondition())) {
            return CommonResponse.error((String)"\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<JSONObject> result = this.commenQueryFieldsService.queryCostDatas(costParameter);
        return CommonResponse.success(result);
    }

    @RequestMapping(value={"updateProportionFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateProportionFlag(@RequestBody JSONObject jsonObject) {
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("billId"))) {
            return CommonResponse.error((String)"\u5355\u636eId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("tableName"))) {
            return CommonResponse.error((String)"\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("proportionFlag"))) {
            return CommonResponse.error((String)"\u5206\u644a\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.commenQueryFieldsService.updateProportionFlagDb(jsonObject);
        return CommonResponse.success();
    }
}

