/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.ejianc.framework.skeleton.template.es.EsEntity;
import com.ejianc.framework.skeleton.template.es.IBaseEsQueryDao;
import com.ejianc.framework.skeleton.template.es.TableInfoTool;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public class BaseServiceImpl<M extends BaseCrudMapper<T>, T>
extends ServiceImpl<M, T>
implements IBaseService<T> {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private IBaseEsQueryDao<T> baseEsQueryDao;
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Override
    @Transactional
    public boolean saveOrUpdate(T entity, boolean syncEs) {
        boolean isSuccess = super.saveOrUpdate(entity);
        if (isSuccess) {
            Field[] fields;
            Class<?> mainClass = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(mainClass);
            Object pid = ReflectionKit.getMethodValue(mainClass, entity, (String)tableInfo.getKeyProperty());
            ArrayList<Field> subFieldsList = new ArrayList<Field>();
            for (Field field2 : fields = mainClass.getDeclaredFields()) {
                if (!field2.isAnnotationPresent(SubEntity.class)) continue;
                subFieldsList.add(field2);
            }
            if (!ListUtil.isEmpty(subFieldsList)) {
                Object finalEntity = entity;
                subFieldsList.forEach(field -> {
                    String fieldName = field.getName();
                    try {
                        Method m = mainClass.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), null);
                        List subList = (List)m.invoke(finalEntity, (Object[])null);
                        if (!ListUtil.isEmpty((List)subList)) {
                            SubEntity subEntity = field.getAnnotation(SubEntity.class);
                            ArrayList delSubList = new ArrayList();
                            ArrayList delSubListIds = new ArrayList();
                            subList.forEach(s -> {
                                String p = subEntity.pidName();
                                if (StringUtils.isBlank((CharSequence)p)) {
                                    throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6epidName\uff01");
                                }
                                Class<?> subClass = s.getClass();
                                try {
                                    Method subPid = subClass.getDeclaredMethod("set" + p.substring(0, 1).toUpperCase() + p.substring(1), Long.class);
                                    subPid.invoke(s, pid);
                                    Method getRowState = subClass.getSuperclass().getDeclaredMethod("getRowState", null);
                                    String o = (String)getRowState.invoke(s, (Object[])null);
                                    if (StringUtils.isNotBlank((CharSequence)o) && "del".equals(o)) {
                                        Method setDr = subClass.getSuperclass().getDeclaredMethod("setDr", Integer.class);
                                        setDr.invoke(s, 1);
                                        TableInfo subtableInfo = TableInfoHelper.getTableInfo(subClass);
                                        Object idVal = ReflectionKit.getMethodValue(subClass, (Object)s, (String)subtableInfo.getKeyProperty());
                                        delSubListIds.add(idVal);
                                        delSubList.add(s);
                                    } else {
                                        Method setRowState = subClass.getSuperclass().getDeclaredMethod("setRowState", String.class);
                                        setRowState.invoke(s, new Object[]{null});
                                    }
                                }
                                catch (NoSuchMethodException e) {
                                    throw new BusinessException("\u7c7b\u3010" + subClass + "\u3011\u7684\u5b57\u6bb5\u3010" + p + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
                                }
                                catch (IllegalAccessException e) {
                                    throw new BusinessException("\u7c7b\u3010" + subClass + "\u3011\u7684\u5b57\u6bb5\u3010" + p + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
                                }
                                catch (InvocationTargetException e) {
                                    throw new BusinessException("\u7c7b\u3010" + subClass + "\u3011\u7684\u5b57\u6bb5\u3010" + p + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
                                }
                            });
                            String serviceName = subEntity.serviceName();
                            if (StringUtils.isBlank((CharSequence)serviceName)) {
                                throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6e\u5b50\u8868\u5b9e\u73b0\u7c7b\u670d\u52a1\u540d\uff01");
                            }
                            BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                            if (subService == null) {
                                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u5b50\u8868\u6ca1\u6709\u5b9e\u73b0\u7c7b\uff01");
                            }
                            subList.removeAll(delSubList);
                            if (!ListUtil.isEmpty((List)subList)) {
                                subService.saveOrUpdateBatch(subList);
                            }
                            if (!ListUtil.isEmpty(delSubListIds)) {
                                subService.removeByIds(delSubListIds);
                            }
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
                    }
                    catch (IllegalAccessException e) {
                        throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
                    }
                    catch (InvocationTargetException e) {
                        throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
                    }
                });
            }
        } else {
            throw new BusinessException("\u6570\u636e\u5df2\u88ab\u60a8\u7684\u540c\u4e8b\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u83b7\u53d6\u6700\u65b0\u6570\u636e\u518d\u4fdd\u5b58\uff01");
        }
        if (isSuccess && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("insertOrUpdateOne");
            esEntity.setContent(JSON.toJSONString(entity));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean saveOrUpdateBatch(List<T> entityList, int batchSize, boolean syncEs) {
        boolean isSuccess = super.saveOrUpdateBatch(entityList, batchSize);
        if (isSuccess && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(entityList.get(0).getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("insertOrUpdateBatch");
            esEntity.setContent(JSON.toJSONString(entityList));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public T selectById(Serializable id) {
        Field[] fields;
        Object entity = ((BaseCrudMapper)this.baseMapper).selectById(id);
        Class<?> mainClass = entity.getClass();
        for (Field field : fields = mainClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SubEntity.class)) continue;
            SubEntity subEntity = field.getAnnotation(SubEntity.class);
            String serviceName = subEntity.serviceName();
            String fieldName = field.getName();
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6e\u5b50\u8868\u5b9e\u73b0\u7c7b\u670d\u52a1\u540d\uff01");
            }
            BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
            if (subService == null) {
                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u5b50\u8868\u6ca1\u6709\u5b9e\u73b0\u7c7b\uff01");
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put(subEntity.pidName(), new Parameter("eq", (Object)id));
            queryParam.getOrderMap().put("id", "asc");
            List<T> subList = subService.queryList(queryParam, false);
            try {
                Class[] cArg = new Class[]{field.getType()};
                Method setSubList = mainClass.getDeclaredMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), cArg);
                setSubList.invoke(entity, subList);
            }
            catch (NoSuchMethodException e) {
                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u672a\u5b9a\u4e49set\u65b9\u6cd5\uff01");
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u9700\u8981\u662fpublic\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff01");
            }
        }
        return (T)entity;
    }

    @Override
    public boolean removeById(Serializable id, boolean syncEs) {
        boolean isSuccess = false;
        T entity = this.selectById(id);
        if (entity != null) {
            isSuccess = super.removeById(id);
            if (isSuccess) {
                Field[] fields;
                Class<?> mainClass = entity.getClass();
                for (Field field : fields = mainClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(SubEntity.class)) continue;
                    SubEntity subEntity = field.getAnnotation(SubEntity.class);
                    String serviceName = subEntity.serviceName();
                    String fieldName = field.getName();
                    if (StringUtils.isBlank((CharSequence)serviceName)) {
                        throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6e\u5b50\u8868\u5b9e\u73b0\u7c7b\u670d\u52a1\u540d\uff01");
                    }
                    BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                    if (subService == null) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u5b50\u8868\u6ca1\u6709\u5b9e\u73b0\u7c7b\uff01");
                    }
                    try {
                        Method getSubList = mainClass.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), null);
                        List subs = (List)getSubList.invoke(entity, (Object[])null);
                        if (ListUtil.isEmpty((List)subs)) continue;
                        subService.removeByIds(subs.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                    }
                    catch (NoSuchMethodException e) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u672a\u5b9a\u4e49set\u65b9\u6cd5\uff01");
                    }
                    catch (IllegalAccessException e) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u9700\u8981\u662fpublic\u5c5e\u6027\uff01");
                    }
                    catch (InvocationTargetException e) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff01");
                    }
                }
            }
            if (isSuccess && syncEs) {
                TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
                String indexName = tableInfo.getTableName();
                EsEntity esEntity = new EsEntity();
                esEntity.setIndexName(indexName);
                esEntity.setType("deleteById");
                esEntity.setContent(id.toString());
                MqMessage mqMessage = new MqMessage();
                mqMessage.setBody((Object)esEntity);
                this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
            }
        }
        return isSuccess;
    }

    @Override
    public boolean removeByMap(Map<String, Object> columnMap, boolean syncEs) {
        boolean isSuccess = false;
        Collection list = super.listByMap(columnMap);
        if (list != null && list.size() > 0 && (isSuccess = super.removeByMap(columnMap)) && syncEs) {
            Object tableBean = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object bean : list) {
                tableBean = bean;
                BaseEntity baseEntity = (BaseEntity)bean;
                ids.add(baseEntity.getId());
            }
            TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("deleteBatch");
            esEntity.setContent(JSON.toJSONString(ids));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean remove(Wrapper<T> wrapper, boolean syncEs) {
        boolean isSuccess = false;
        List list = super.list(wrapper);
        if (list != null && list.size() > 0 && (isSuccess = super.remove(wrapper)) && syncEs) {
            Object tableBean = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object bean : list) {
                tableBean = bean;
                BaseEntity baseEntity = (BaseEntity)bean;
                ids.add(baseEntity.getId());
            }
            TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("deleteBatch");
            esEntity.setContent(JSON.toJSONString(ids));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList, boolean syncEs) {
        boolean isSuccess = false;
        for (Serializable serializable : idList) {
            isSuccess = this.removeById(serializable, syncEs);
            if (isSuccess) continue;
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
        return isSuccess;
    }

    @Override
    public boolean update(T entity, Wrapper<T> updateWrapper, boolean syncEs) {
        boolean isSuccess = super.update(entity, updateWrapper);
        if (isSuccess && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("insertOrUpdateOne");
            esEntity.setContent(JSON.toJSONString(entity));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public List<T> queryList(QueryParam queryParam, boolean isEs) {
        List list;
        if (isEs) {
            list = this.baseEsQueryDao.selectList(queryParam);
        } else {
            List complexParams;
            QueryWrapper queryWrapper = new QueryWrapper();
            Map params = queryParam.getParams();
            if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText()) && !ListUtil.isEmpty((List)queryParam.getFuzzyFields())) {
                String searchText = queryParam.getSearchText();
                List fuzzyFields = queryParam.getFuzzyFields();
                if (queryParam.getFuzzyFields().size() == 1) {
                    queryWrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)queryParam.getFuzzyFields().get(0))), (Object)searchText);
                } else {
                    queryWrapper.and(wrapper -> {
                        for (int i = 0; i < fuzzyFields.size(); ++i) {
                            wrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)queryParam.getFuzzyFields().get(i))), (Object)searchText);
                            if (i == fuzzyFields.size() - 1) continue;
                            wrapper.or();
                        }
                        return wrapper;
                    });
                }
            }
            BaseServiceImpl.setParam(queryWrapper, params);
            if (StringUtils.isNotEmpty((CharSequence)queryParam.getSearchObject())) {
                BaseServiceImpl.setSearchObjectParam(queryWrapper, JSONObject.parseObject((String)queryParam.getSearchObject()));
            }
            if (!ListUtil.isEmpty((List)(complexParams = queryParam.getComplexParams()))) {
                complexParams.forEach(c -> {
                    if ("and".equals(c.getLogic())) {
                        queryWrapper.and(w -> BaseServiceImpl.setWrapper(w, c));
                    } else {
                        queryWrapper.or(w -> BaseServiceImpl.setWrapper(w, c));
                    }
                });
            }
            LinkedHashMap orderMap = queryParam.getOrderMap();
            for (String key : orderMap.keySet()) {
                String value = (String)orderMap.get(key);
                if ("asc".equals(value.toLowerCase())) {
                    queryWrapper.orderByAsc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
                    continue;
                }
                if (!"desc".equals(value.toLowerCase())) continue;
                queryWrapper.orderByDesc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
            }
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    private static <T> QueryWrapper<T> setWrapper(QueryWrapper<T> w, ComplexParam c) {
        List complexParams;
        if (c.getParams() != null && !c.getParams().isEmpty()) {
            BaseServiceImpl.setParam(w, c.getParams());
        }
        if (!ListUtil.isEmpty((List)(complexParams = c.getComplexParams()))) {
            complexParams.forEach(complex -> {
                if ("and".equals(complex.getLogic())) {
                    w.and(wrapper -> BaseServiceImpl.setWrapper(wrapper, complex));
                } else {
                    w.or(wrapper -> BaseServiceImpl.setWrapper(wrapper, complex));
                }
            });
        }
        return w;
    }

    @Override
    public IPage<T> queryPage(QueryParam queryParam, boolean isEs) {
        IPage page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page = isEs ? this.baseEsQueryDao.selectPage(page, queryParam) : this.page(page, (Wrapper)BaseServiceImpl.changeToQueryWrapper(queryParam));
        return page;
    }

    private static <T> void setParam(QueryWrapper<T> queryWrapper, Map<String, Parameter> params) {
        for (Map.Entry<String, Parameter> entry : params.entrySet()) {
            String type;
            Parameter param = entry.getValue();
            switch (type = param.getType()) {
                case "eq": {
                    if (null == param.getValue()) {
                        queryWrapper.isNull((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()));
                        break;
                    }
                    queryWrapper.eq((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "ne": {
                    if (null == param.getValue()) {
                        queryWrapper.isNotNull((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()));
                        break;
                    }
                    queryWrapper.ne((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "in": {
                    if (param.getValue() instanceof List) {
                        queryWrapper.in((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), (Collection)((List)param.getValue()));
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    queryWrapper.in((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), paramArr);
                    break;
                }
                case "not_in": {
                    if (param.getValue() instanceof List) {
                        queryWrapper.notIn((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), (Collection)((List)param.getValue()));
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    queryWrapper.notIn((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), paramArr);
                    break;
                }
                case "like": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "not_like": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.notLike((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "like_left": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.likeLeft((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "like_right": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.likeRight((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "between": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    queryWrapper.between((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), paramArr[0], paramArr[1]);
                    break;
                }
                case "lt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.lt((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "le": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.le((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "gt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.gt((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "ge": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.ge((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                }
            }
        }
    }

    private static <T> void setSearchObjectParam(QueryWrapper<T> queryWrapper, JSONObject params) {
        for (String key : params.keySet()) {
            queryWrapper.eq((Object)CamelAndUnderLineConverter.humpToLine((String)key), params.get((Object)key));
        }
    }

    public static <T> QueryWrapper<T> changeToQueryWrapper(QueryParam queryParam) {
        List complexParams;
        QueryWrapper queryWrapper = new QueryWrapper();
        Map params = queryParam.getParams();
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText()) && !ListUtil.isEmpty((List)queryParam.getFuzzyFields())) {
            String searchText = queryParam.getSearchText();
            List fuzzyFields = queryParam.getFuzzyFields();
            if (queryParam.getFuzzyFields().size() == 1) {
                queryWrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)queryParam.getFuzzyFields().get(0))), (Object)searchText);
            } else {
                queryWrapper.and(wrapper -> {
                    for (int i = 0; i < fuzzyFields.size(); ++i) {
                        wrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)queryParam.getFuzzyFields().get(i))), (Object)searchText);
                        if (i == fuzzyFields.size() - 1) continue;
                        wrapper.or();
                    }
                    return wrapper;
                });
            }
        }
        BaseServiceImpl.setParam(queryWrapper, params);
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getSearchObject())) {
            BaseServiceImpl.setSearchObjectParam(queryWrapper, JSONObject.parseObject((String)queryParam.getSearchObject()));
        }
        if (!ListUtil.isEmpty((List)(complexParams = queryParam.getComplexParams()))) {
            complexParams.forEach(c -> {
                if ("and".equals(c.getLogic())) {
                    queryWrapper.and(w -> BaseServiceImpl.setWrapper(w, c));
                } else {
                    queryWrapper.or(w -> BaseServiceImpl.setWrapper(w, c));
                }
            });
        }
        LinkedHashMap orderMap = queryParam.getOrderMap();
        for (String key : orderMap.keySet()) {
            String value = (String)orderMap.get(key);
            if ("asc".equals(value.toLowerCase())) {
                queryWrapper.orderByAsc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
                continue;
            }
            if (!"desc".equals(value.toLowerCase())) continue;
            queryWrapper.orderByDesc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
        }
        return queryWrapper;
    }
}

