package com.ejianc.framework.skeleton.billState.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.mapper.CommonUpdateBillStateMapper;
import com.ejianc.framework.skeleton.billState.param.QueryBillDetailParam;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.billState.param.UpdateBillStateParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;

/**  
  * Title: CommonUpdateBillStateServiceImpl  
  * Description: 
  * @author liyongjia  
  * @date 2020-05-14    
  */
@Service
public class CommonUpdateBillStateServiceImpl implements CommonUpdateBillStateService {
	private final static org.slf4j.Logger Log = LoggerFactory.getLogger(CommonUpdateBillStateServiceImpl.class);

	@Autowired
	private CommonUpdateBillStateMapper mapper;
	@Autowired
	private IMdAttributeApi mdAttributeApi;
	
	@Override
	public CommonResponse<String> updateBillState(UpdateBillStateParam updateBillStateParam) {
		Log.info("修改单据状态开始---------------------将单据："+updateBillStateParam.getBillId()+"的billState修改为"+updateBillStateParam.getBillState()+"");
		//先查询下单据之前的状态
		String billState = mapper.queryBillState(updateBillStateParam);
		//修改单据状态
		mapper.updateBillState(updateBillStateParam);
		Log.info("修改单据状态成功---------------------将表："+updateBillStateParam.getTableName() +"中的单据："+updateBillStateParam.getBillId()+"的billState修改为"+updateBillStateParam.getBillState()+"");
		return CommonResponse.success("查询成功", billState);
		
	}

	@Override
	public JSONObject queryBillDetail(QueryBillDetailParam queryBillDetailParam) {
		//查询元数据表结构
		List<String> columnList = mapper.queryTableAttrList(queryBillDetailParam.getTableName());
		Map<String, String> columnMap = new HashMap<String, String>();
		if(columnList != null && columnList.size() > 0) {
			for(String column:columnList) {
				columnMap.put(column, column);
			}
		}
		CommonResponse<List<MdAttributeVO>> attributeResponse = mdAttributeApi.queryMainAttributeList(Long.parseLong(queryBillDetailParam.getMetadataId()));
		if(attributeResponse.isSuccess()) {
			List<MdAttributeVO> mdAttributeVos = attributeResponse.getData();
			StringBuffer paramBuffer = new StringBuffer("");
			if(mdAttributeVos != null && mdAttributeVos.size() > 0) {
				for(MdAttributeVO mdAttributeVo:mdAttributeVos) {
					if(columnMap.containsKey(mdAttributeVo.getColumnName())) {
						paramBuffer.append(mdAttributeVo.getColumnName()).append(" as ").append(mdAttributeVo.getAttributeName()).append(",");
					}
				}
				if(StringUtils.isNotBlank(paramBuffer)) {
					String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
					JSONObject jsonObject = mapper.queryBillDetail(queryBillDetailParam.getTableName(), parameter, queryBillDetailParam.getBillId());
					return jsonObject;
				}
			}
		}
		return null;
	}

	@Override
	public String queryQuoteById(QueryQuoteParam queryQuoteParam) {
		String count = mapper.queryQuoteById(queryQuoteParam.getBillId(),queryQuoteParam.getTableName(),queryQuoteParam.getColumn(), InvocationInfoProxy.getTenantid());
		return count;
	}
	
}
