package com.ejianc.framework.skeleton.refer.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.http.client.ClientProtocolException;
import org.springframework.data.redis.core.RedisTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;

/**
 * 根据redis和http rest 托底获取参照实体信息
 * 
 * @author guominga 2020年02月13日
 *
 */
public class ReferObjectUtil {

	private static final String REFER_CACHE_KEY = "refer_cache_key:";
	
	/**
	 * 
	 * @param valueId
	 *            单个档案直接传:id
	 * @param referCode
	 * @return
	 * @throws IOException
	 * @throws GeneralSecurityException
	 * @throws ClientProtocolException
	 */
	@SuppressWarnings("unchecked")
	public static JSONArray getReferEntityValue(String value, String referCode) throws Exception {
		MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
		JSONArray jsonArray = null;
		if(value.endsWith(",")) {
			value = value.substring(0, value.length()-1);
		}
		// 走redis
		String cacheKey = REFER_CACHE_KEY + referCode + ":" + value;
		RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
		
		Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
		if (cacheValue != null) {
			jsonArray = JSON.parseArray(cacheValue.toString());
		} else {
			String referData = getReferRestUrl(referCode);
			JSONObject json = JSON.parseObject(referData);
			String referUrl = json.get("projectName").toString();
			Map<String, Object> reflist = new HashMap<>();
			reflist = (Map<String, Object>) json.get("refMapList");
			reflist.put("valueId", value);
			reflist.put("databaseName", json.get("databaseName"));
			reflist.put("tableName", json.get("tableName"));
			String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getrefervalue";
			String jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
			jsonArray = JSON.parseArray(jsonbackstr);
			if(jsonArray.size() > 0) {
				redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 10, TimeUnit.MINUTES);
			}
		}
		return jsonArray;
	}
	
	/**
	 * 通过元数据服务获取实体信息
	 * 
	 * @param className
	 * @return
	 */
	private static String getReferRestUrl(String referCode) {
		String data = null;
		MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
		String backData = null;
		try {
			backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
		} catch (ClientProtocolException e) {
			ExceptionUtil.wrappException(e);
		} catch (GeneralSecurityException e) {
			ExceptionUtil.wrappException(e);
		} catch (IOException e) {
			ExceptionUtil.wrappException(e);
		}

		JSONObject jsonobject = JSON.parseObject(backData);
		if(jsonobject.getString("code").equals("0")){
			if(jsonobject.getString("data")!=null){
				data = JSON.parseObject(jsonobject.getString("data")).toJSONString();
			}
		}else{
			ExceptionUtil.wrappBusinessException("参照编码" + referCode + "的实体没有发布元数据!");
		}
		return data;

	}
}
