/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.billState.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.mapper.CommonUpdateBillStateMapper;
import com.ejianc.framework.skeleton.billState.param.QueryBillDetailParam;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.billState.param.UpdateBillStateParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonUpdateBillStateServiceImpl
implements CommonUpdateBillStateService {
    private static final Logger Log = LoggerFactory.getLogger(CommonUpdateBillStateServiceImpl.class);
    @Autowired
    private CommonUpdateBillStateMapper mapper;
    @Autowired
    private IMdAttributeApi mdAttributeApi;

    @Override
    public CommonResponse<String> updateBillState(UpdateBillStateParam updateBillStateParam) {
        Log.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u5f00\u59cb---------------------\u5c06\u5355\u636e\uff1a" + updateBillStateParam.getBillId() + "\u7684billState\u4fee\u6539\u4e3a" + updateBillStateParam.getBillState() + "");
        String billState = this.mapper.queryBillState(updateBillStateParam);
        this.mapper.updateBillState(updateBillStateParam);
        Log.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u6210\u529f---------------------\u5c06\u8868\uff1a" + updateBillStateParam.getTableName() + "\u4e2d\u7684\u5355\u636e\uff1a" + updateBillStateParam.getBillId() + "\u7684billState\u4fee\u6539\u4e3a" + updateBillStateParam.getBillState() + "");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)billState);
    }

    @Override
    public JSONObject queryBillDetail(QueryBillDetailParam queryBillDetailParam) {
        CommonResponse attributeResponse;
        List<String> columnList = this.mapper.queryTableAttrList(queryBillDetailParam.getTableName());
        HashMap<String, String> columnMap = new HashMap<String, String>();
        if (columnList != null && columnList.size() > 0) {
            for (String column : columnList) {
                columnMap.put(column, column);
            }
        }
        if ((attributeResponse = this.mdAttributeApi.queryMainAttributeList(Long.valueOf(Long.parseLong(queryBillDetailParam.getMetadataId())))).isSuccess()) {
            List mdAttributeVos = (List)attributeResponse.getData();
            StringBuffer paramBuffer = new StringBuffer("");
            if (mdAttributeVos != null && mdAttributeVos.size() > 0) {
                for (MdAttributeVO mdAttributeVo : mdAttributeVos) {
                    if (!columnMap.containsKey(mdAttributeVo.getColumnName())) continue;
                    paramBuffer.append(mdAttributeVo.getColumnName()).append(" as ").append(mdAttributeVo.getAttributeName()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)paramBuffer)) {
                    String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
                    JSONObject jsonObject = this.mapper.queryBillDetail(queryBillDetailParam.getTableName(), parameter, queryBillDetailParam.getBillId());
                    return jsonObject;
                }
            }
        }
        return null;
    }

    @Override
    public String queryQuoteById(QueryQuoteParam queryQuoteParam) {
        String count = this.mapper.queryQuoteById(queryQuoteParam.getBillId(), queryQuoteParam.getTableName(), queryQuoteParam.getColumn(), InvocationInfoProxy.getTenantid());
        return count;
    }
}

