/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.dataPush.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.util.OpenApiHttpTools;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class SystemDataPushServiceImpl
implements ISystemDataPushService {
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private OpenApiHttpTools openApiHttpTools;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public CommonResponse<String> exchangeDataWithThirdSystem(String url, RequestMethod method, String postData, String systemId) {
        if (StringUtils.isEmpty((CharSequence)systemId)) {
            return CommonResponse.error((String)"systemId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (RequestMethod.POST.name().equals(method.name())) {
            return this.openApiHttpTools.postByJson(systemId, null, null, null, url, postData);
        }
        return this.openApiHttpTools.getByJson(systemId, null, null, null, url, null);
    }

    @Override
    public CommonResponse<String> exchangeDataWithEachLinkSystem(String url, RequestMethod method, String postData, String supplierId) {
        block8: {
            if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)supplierId)) {
                return CommonResponse.error((String)"url\u3001supplierId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.redisTemplate.opsForValue().get((Object)("EachLink-Open-Api-Info-" + supplierId)) == null) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", supplierId);
                try {
                    String result = ReferHttpClientUtils.get(this.baseHost + "ejc-share-web/supplier/generateAccessToken", params, ReferHttpClientUtils.getHeaders());
                    if (StringUtils.isNotEmpty((CharSequence)result)) {
                        JSONObject res = JSONObject.parseObject((String)result);
                        if (res.getInteger("code") != 0) {
                            return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
                        }
                        break block8;
                    }
                    return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                    return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
                }
            }
        }
        String cacheData = this.redisTemplate.opsForValue().get((Object)("EachLink-Open-Api-Info-" + supplierId)).toString();
        String appHost = cacheData.split("------")[0];
        String appId = cacheData.split("------")[1];
        String appSecret = cacheData.split("------")[2];
        if (RequestMethod.POST.name().equals(method.name())) {
            return this.openApiHttpTools.postByJson(null, appId, appSecret, appHost, url, postData);
        }
        return this.openApiHttpTools.getByJson(null, appId, appSecret, appHost, url, null);
    }

    @Override
    public CommonResponse<String> exchangeDataWithUniversal(String url, RequestMethod method, String postData, String appId, String appSecret, String appHost) {
        if (StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)appSecret) || StringUtils.isEmpty((CharSequence)appHost)) {
            return CommonResponse.error((String)"appId\u3001appSecret\u3001appHost\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (RequestMethod.POST.name().equals(method.name())) {
            return this.openApiHttpTools.postByJson(null, appId, appSecret, appHost, url, postData);
        }
        return this.openApiHttpTools.getByJson(null, appId, appSecret, appHost, url, null);
    }
}

