/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.refer.util;

import com.ejianc.framework.skeleton.refer.util.CacheObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class JedisCacheTool {
    @Autowired
    private JedisPool jedisPool;
    private static JdkSerializationRedisSerializer redisSerializer = new JdkSerializationRedisSerializer();

    public void putBatch(List<CacheObject> cacheObjects) {
        Jedis jedis = this.jedisPool.getResource();
        Pipeline pipeline = jedis.pipelined();
        for (CacheObject cacheObject : cacheObjects) {
            pipeline.set(redisSerializer.serialize((Object)cacheObject.getKey()), redisSerializer.serialize(cacheObject.getValue()));
        }
        pipeline.sync();
        jedis.close();
    }

    public Map<Object, Object> getBatch(List<Object> keys) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Jedis jedis = this.jedisPool.getResource();
        Pipeline pipeline = jedis.pipelined();
        ArrayList<Response> results = new ArrayList<Response>();
        for (Object key : keys) {
            Response result = pipeline.get(redisSerializer.serialize(key));
            results.add(result);
        }
        pipeline.sync();
        for (int i = 0; i < results.size(); ++i) {
            Response result = (Response)results.get(i);
            Object obj = redisSerializer.deserialize((byte[])result.get());
            if (obj == null) continue;
            map.put(keys.get(i), obj);
        }
        jedis.close();
        return map;
    }

    public void deleteBatch(List<Object> keys) {
        Jedis jedis = this.jedisPool.getResource();
        Pipeline pipeline = jedis.pipelined();
        pipeline.del(redisSerializer.serialize(keys));
        pipeline.sync();
        jedis.close();
    }

    public Object get(Object key) {
        Jedis jedis = this.jedisPool.getResource();
        Pipeline pipeline = jedis.pipelined();
        Response result = pipeline.get(redisSerializer.serialize(key));
        pipeline.sync();
        Object obj = redisSerializer.deserialize((byte[])result.get());
        jedis.close();
        return obj;
    }

    public void put(Object key, Object value) {
        Jedis jedis = this.jedisPool.getResource();
        Pipeline pipeline = jedis.pipelined();
        pipeline.set(redisSerializer.serialize(key), redisSerializer.serialize(value));
        pipeline.sync();
        jedis.close();
    }

    public void delete(Object key) {
        Jedis jedis = this.jedisPool.getResource();
        Pipeline pipeline = jedis.pipelined();
        pipeline.del(redisSerializer.serialize(key));
        pipeline.sync();
        jedis.close();
    }
}

