/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template.es;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.es.IBaseEsQueryDao;
import com.ejianc.framework.skeleton.template.es.TableInfoTool;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BaseEsQueryDao<T>
implements IBaseEsQueryDao<T> {
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String ASC = "asc";
    @Autowired(required=false)
    private RestHighLevelClient client;

    private Class<T> getTClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public Long selectCount(QueryParam queryParam) {
        Long total = 0L;
        TableInfo tableInfo = TableInfoTool.initTableInfo(this.getTClass());
        String index = tableInfo.getTableName();
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder mainBool = QueryBuilders.boolQuery();
        BoolQueryBuilder equalBool = QueryBuilders.boolQuery();
        BoolQueryBuilder likeBool = null;
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            TermQueryBuilder queryBuilder = null;
            if ("eq".equals(param.getType())) {
                queryBuilder = QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)param.getValue());
            } else if ("like".equals(param.getType())) {
                queryBuilder = QueryBuilders.matchQuery((String)((String)entry.getKey()), (Object)param.getValue());
            } else if ("in".equals(param.getType())) {
                queryBuilder = QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)param.getValue().toString().split(","));
            } else if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true);
            } else if ("gt".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).gt(param.getValue());
            } else if ("ge".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).gte(param.getValue());
            } else if ("lt".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).lt(param.getValue());
            } else if ("le".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).lte(param.getValue());
            }
            if (queryBuilder == null) continue;
            equalBool.must((QueryBuilder)queryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText())) {
            likeBool = new BoolQueryBuilder();
            List fields = queryParam.getFuzzyFields();
            for (String field : fields) {
                likeBool.should((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)queryParam.getSearchText()));
            }
        }
        if (likeBool != null) {
            mainBool.must((QueryBuilder)equalBool).must((QueryBuilder)likeBool);
        } else {
            mainBool.must((QueryBuilder)equalBool);
        }
        LinkedHashMap orderMap = queryParam.getOrderMap();
        if (orderMap != null && !orderMap.isEmpty()) {
            for (Map.Entry entry : orderMap.entrySet()) {
                sourceBuilder.sort(new FieldSortBuilder((String)entry.getKey()).order(ASC.equals(((String)entry.getValue()).toLowerCase()) ? SortOrder.ASC : SortOrder.DESC));
            }
        }
        sourceBuilder.query((QueryBuilder)mainBool);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            total = this.client.search((SearchRequest)searchRequest, (RequestOptions)RequestOptions.DEFAULT).getHits().getTotalHits().value;
        }
        catch (IOException iOException) {
            try {
                total = this.client.search((SearchRequest)searchRequest, (RequestOptions)RequestOptions.DEFAULT).getHits().getTotalHits().value;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e \u53c2\u6570map \u6761\u4ef6\uff0c\u67e5\u8be2\u603b\u8bb0\u5f55\u6570\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return total;
    }

    @Override
    public List<T> selectList(QueryParam queryParam) {
        ArrayList<Object> list = new ArrayList<Object>();
        TableInfo tableInfo = TableInfoTool.initTableInfo(this.getTClass());
        String index = tableInfo.getTableName();
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder mainBool = QueryBuilders.boolQuery();
        BoolQueryBuilder equalBool = QueryBuilders.boolQuery();
        BoolQueryBuilder likeBool = null;
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            Object queryBuilder = null;
            if ("eq".equals(param.getType())) {
                queryBuilder = QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)param.getValue());
            } else if ("like".equals(param.getType())) {
                queryBuilder = QueryBuilders.matchQuery((String)((String)entry.getKey()), (Object)param.getValue());
            } else if ("in".equals(param.getType())) {
                queryBuilder = QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)param.getValue().toString().split(","));
            } else if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true);
            } else if ("gt".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).gt(param.getValue());
            } else if ("ge".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).gte(param.getValue());
            } else if ("lt".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).lt(param.getValue());
            } else if ("le".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).lte(param.getValue());
            }
            if (queryBuilder == null) continue;
            equalBool.must((QueryBuilder)queryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText())) {
            likeBool = new BoolQueryBuilder();
            List fields = queryParam.getFuzzyFields();
            for (String field : fields) {
                likeBool.should((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)queryParam.getSearchText()));
            }
        }
        if (likeBool != null) {
            mainBool.must((QueryBuilder)equalBool).must((QueryBuilder)likeBool);
        } else {
            mainBool.must((QueryBuilder)equalBool);
        }
        LinkedHashMap orderMap = queryParam.getOrderMap();
        if (orderMap != null && !orderMap.isEmpty()) {
            for (Map.Entry entry : orderMap.entrySet()) {
                sourceBuilder.sort(new FieldSortBuilder((String)entry.getKey()).order(ASC.equals(((String)entry.getValue()).toLowerCase()) ? SortOrder.ASC : SortOrder.DESC));
            }
        }
        sourceBuilder.query((QueryBuilder)mainBool);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, this.getTClass()));
            }
        }
        catch (IOException iOException) {
            try {
                SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                for (SearchHit hit : hits) {
                    String sourceAsString = hit.getSourceAsString();
                    list.add(JSON.parseObject((String)sourceAsString, this.getTClass()));
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return list;
    }

    @Override
    public IPage<T> selectPage(IPage<T> page, QueryParam queryParam) {
        TableInfo tableInfo = TableInfoTool.initTableInfo(this.getTClass());
        String index = tableInfo.getTableName();
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder mainBool = QueryBuilders.boolQuery();
        BoolQueryBuilder equalBool = QueryBuilders.boolQuery();
        BoolQueryBuilder likeBool = null;
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            TermQueryBuilder queryBuilder = null;
            if ("eq".equals(param.getType())) {
                queryBuilder = QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)param.getValue());
            } else if ("like".equals(param.getType())) {
                queryBuilder = QueryBuilders.matchQuery((String)((String)entry.getKey()), (Object)param.getValue());
            } else if ("in".equals(param.getType())) {
                queryBuilder = QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)param.getValue().toString().split(","));
            } else if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true);
            } else if ("gt".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).gt(param.getValue());
            } else if ("ge".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).gte(param.getValue());
            } else if ("lt".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).lt(param.getValue());
            } else if ("le".equals(param.getType())) {
                queryBuilder = QueryBuilders.rangeQuery((String)((String)entry.getKey())).lte(param.getValue());
            }
            if (queryBuilder == null) continue;
            equalBool.must((QueryBuilder)queryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText())) {
            likeBool = new BoolQueryBuilder();
            List fields = queryParam.getFuzzyFields();
            for (String field : fields) {
                likeBool.should((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)queryParam.getSearchText()));
            }
        }
        if (likeBool != null) {
            mainBool.must((QueryBuilder)equalBool).must((QueryBuilder)likeBool);
        } else {
            mainBool.must((QueryBuilder)equalBool);
        }
        LinkedHashMap orderMap = queryParam.getOrderMap();
        if (orderMap != null && !orderMap.isEmpty()) {
            for (Map.Entry entry : orderMap.entrySet()) {
                sourceBuilder.sort(new FieldSortBuilder((String)entry.getKey()).order(ASC.equals(((String)entry.getValue()).toLowerCase()) ? SortOrder.ASC : SortOrder.DESC));
            }
        }
        sourceBuilder.query((QueryBuilder)mainBool);
        sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        sourceBuilder.size(queryParam.getPageSize());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                arrayList.add(JSON.parseObject((String)sourceAsString, this.getTClass()));
            }
            page.setRecords(arrayList);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException iOException) {
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                for (SearchHit hit : hits) {
                    String sourceAsString = hit.getSourceAsString();
                    list.add(JSON.parseObject((String)sourceAsString, this.getTClass()));
                }
                page.setRecords(list);
                page.setTotal(hits.getTotalHits().value);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return page;
    }
}

