/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template.es;

import com.ejianc.framework.skeleton.template.es.ESProperties;
import com.ejianc.framework.skeleton.template.es.HighRestClientFactoryBean;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RestHighLevelClient.class, HighRestClientFactoryBean.class, RestClient.class})
@ConditionalOnProperty(prefix="ejc.elasticsearch.rest-high-level", name={"cluster-nodes"})
@EnableConfigurationProperties(value={ESProperties.class})
public class ESAutoConfiguration {
    @Autowired
    private ESProperties esProperties;

    @Bean
    @ConditionalOnMissingBean
    public RestHighLevelClient restHighLevelClient() throws Exception {
        HighRestClientFactoryBean highRestClientFactoryBean = new HighRestClientFactoryBean();
        highRestClientFactoryBean.setEsProperties(this.esProperties);
        highRestClientFactoryBean.afterPropertiesSet();
        return highRestClientFactoryBean.getObject();
    }
}

