/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.ejianc.framework.skeleton.template.es.EsEntity;
import com.ejianc.framework.skeleton.template.es.IBaseEsQueryDao;
import com.ejianc.framework.skeleton.template.es.TableInfoTool;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public class BaseServiceImpl<M extends BaseCrudMapper<T>, T>
extends ServiceImpl<M, T>
implements IBaseService<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private IBaseEsQueryDao<T> baseEsQueryDao;
    @Autowired
    private ICustomBusinessDataService customBusinessDataService;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${extend.field.mode:false}")
    private Boolean extFieldsMode;
    private static String reg = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(from|concat|updatexml|select|update|union|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|drop|execute)\\b)";
    private static Pattern sqlPattern = Pattern.compile(reg, 2);

    @Override
    @Transactional
    public boolean saveOrUpdate(T entity, boolean syncEs) {
        boolean isSuccess = super.saveOrUpdate(entity);
        if (isSuccess) {
            Field[] fields;
            Class<?> mainClass = entity.getClass();
            if (this.extFieldsMode.booleanValue()) {
                try {
                    Method customFieldMethod = mainClass.getSuperclass().getDeclaredMethod("getCustomField", null);
                    Map customFieldDataMap = (Map)customFieldMethod.invoke(entity, (Object[])null);
                    if (customFieldDataMap != null && !customFieldDataMap.isEmpty()) {
                        CustomBusinessDataVO customBusinessDataVO = new CustomBusinessDataVO();
                        Method mainPkIdMethod = mainClass.getSuperclass().getDeclaredMethod("getId", null);
                        Long l = (Long)mainPkIdMethod.invoke(entity, (Object[])null);
                        customBusinessDataVO.setBusinessId(l);
                        customBusinessDataVO.setBusinessData(JSON.toJSONString((Object)customFieldDataMap));
                        ArrayList<CustomBusinessDataVO> customBusinessDataVos = new ArrayList<CustomBusinessDataVO>();
                        customBusinessDataVos.add(customBusinessDataVO);
                        CommonResponse<String> mainResponse = this.customBusinessDataService.saveOrUpdateData(customBusinessDataVos);
                        if (!mainResponse.isSuccess()) {
                            throw new BusinessException("\u4e3b\u8868\u6269\u5c55\u5b57\u6bb5\u63d2\u5165\u5931\u8d25\uff01");
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("\u6269\u5c55\u6570\u636e\u5b58\u50a8\u6216\u8bfb\u53d6\u5931\u8d25\uff0c \u5982\u679c\u6709\u4f7f\u7528\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u5728\u60a8\u7684\u5fae\u670d\u52a1\u6570\u636e\u5e93\u4e2d\u5efa\u7acbejc_custom_businessdata\u8868");
                }
            }
            TableInfo tableInfo = TableInfoHelper.getTableInfo(mainClass);
            Object pid = ReflectionKit.getMethodValue(mainClass, entity, (String)tableInfo.getKeyProperty());
            ArrayList<Field> subFieldsList = new ArrayList<Field>();
            for (Field field2 : fields = mainClass.getDeclaredFields()) {
                if (!field2.isAnnotationPresent(SubEntity.class)) continue;
                subFieldsList.add(field2);
            }
            if (!ListUtil.isEmpty(subFieldsList)) {
                T t = entity;
                subFieldsList.forEach(field -> {
                    block11: {
                        String fieldName = field.getName();
                        try {
                            Method m = mainClass.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), null);
                            List subList = (List)m.invoke(finalEntity, (Object[])null);
                            ArrayList<CustomBusinessDataVO> subCustomBusinessDataVos = new ArrayList<CustomBusinessDataVO>();
                            if (ListUtil.isEmpty((List)subList)) break block11;
                            SubEntity subEntity = field.getAnnotation(SubEntity.class);
                            ArrayList delSubList = new ArrayList();
                            ArrayList delSubListIds = new ArrayList();
                            subList.forEach(s -> {
                                String p = subEntity.pidName();
                                if (StringUtils.isBlank((CharSequence)p)) {
                                    throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6epidName\uff01");
                                }
                                Class<?> subClass = s.getClass();
                                try {
                                    Method subPid = subClass.getDeclaredMethod("set" + p.substring(0, 1).toUpperCase() + p.substring(1), Long.class);
                                    subPid.invoke(s, pid);
                                    Method getRowState = subClass.getSuperclass().getDeclaredMethod("getRowState", null);
                                    String o = (String)getRowState.invoke(s, (Object[])null);
                                    Method subCustomFieldMethod = subClass.getSuperclass().getDeclaredMethod("getCustomField", null);
                                    Map subCustomFieldMap = (Map)subCustomFieldMethod.invoke(s, (Object[])null);
                                    if (StringUtils.isNotBlank((CharSequence)o) && "del".equals(o)) {
                                        Method setDr = subClass.getSuperclass().getDeclaredMethod("setDr", Integer.class);
                                        setDr.invoke(s, 1);
                                        TableInfo subtableInfo = TableInfoHelper.getTableInfo(subClass);
                                        Object idVal = ReflectionKit.getMethodValue(subClass, (Object)s, (String)subtableInfo.getKeyProperty());
                                        delSubListIds.add(idVal);
                                        delSubList.add(s);
                                        if (subCustomFieldMap != null && !subCustomFieldMap.isEmpty()) {
                                            CustomBusinessDataVO subCustomBusinessDataVO = new CustomBusinessDataVO();
                                            Method subPkIdMethod = subClass.getSuperclass().getDeclaredMethod("getId", null);
                                            Long businessId = (Long)subPkIdMethod.invoke(s, (Object[])null);
                                            subCustomBusinessDataVO.setBusinessId(businessId);
                                            subCustomBusinessDataVos.add(subCustomBusinessDataVO);
                                        }
                                    } else {
                                        Method setRowState = subClass.getSuperclass().getDeclaredMethod("setRowState", String.class);
                                        setRowState.invoke(s, new Object[]{null});
                                        CustomBusinessDataVO subCustomBusinessDataVO = new CustomBusinessDataVO();
                                        if (subCustomFieldMap != null && !subCustomFieldMap.isEmpty()) {
                                            Method subPkIdMethod = subClass.getSuperclass().getDeclaredMethod("getId", null);
                                            Long businessId = (Long)subPkIdMethod.invoke(s, (Object[])null);
                                            subCustomBusinessDataVO.setBusinessId(businessId);
                                            subCustomBusinessDataVO.setBusinessData(JSON.toJSONString((Object)subCustomFieldMap));
                                        } else {
                                            Method subPkIdMethod = subClass.getSuperclass().getDeclaredMethod("getId", null);
                                            Long businessId = (Long)subPkIdMethod.invoke(s, (Object[])null);
                                            subCustomBusinessDataVO.setBusinessId(businessId);
                                        }
                                        subCustomBusinessDataVos.add(subCustomBusinessDataVO);
                                    }
                                }
                                catch (NoSuchMethodException e) {
                                    throw new BusinessException("\u7c7b\u3010" + subClass + "\u3011\u7684\u5b57\u6bb5\u3010" + p + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
                                }
                                catch (IllegalAccessException e) {
                                    throw new BusinessException("\u7c7b\u3010" + subClass + "\u3011\u7684\u5b57\u6bb5\u3010" + p + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
                                }
                                catch (InvocationTargetException e) {
                                    throw new BusinessException("\u7c7b\u3010" + subClass + "\u3011\u7684\u5b57\u6bb5\u3010" + p + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
                                }
                            });
                            String serviceName = subEntity.serviceName();
                            if (StringUtils.isBlank((CharSequence)serviceName)) {
                                throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6e\u5b50\u8868\u5b9e\u73b0\u7c7b\u670d\u52a1\u540d\uff01");
                            }
                            BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                            if (subService == null) {
                                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u5b50\u8868\u6ca1\u6709\u5b9e\u73b0\u7c7b\uff01");
                            }
                            subList.removeAll(delSubList);
                            if (!ListUtil.isEmpty((List)subList)) {
                                subService.saveOrUpdateBatch(subList);
                            }
                            if (!ListUtil.isEmpty(delSubListIds)) {
                                subService.removeByIds(delSubListIds);
                            }
                            try {
                                if (this.extFieldsMode.booleanValue() && !ListUtil.isEmpty(subCustomBusinessDataVos)) {
                                    this.customBusinessDataService.saveOrUpdateData(subCustomBusinessDataVos);
                                }
                            }
                            catch (Exception e) {
                                this.logger.warn("\u6269\u5c55\u6570\u636e\u5b58\u50a8\u6216\u8bfb\u53d6\u5931\u8d25\uff0c \u5982\u679c\u6709\u4f7f\u7528\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u5728\u60a8\u7684\u5fae\u670d\u52a1\u6570\u636e\u5e93\u4e2d\u5efa\u7acbejc_custom_businessdata\u8868");
                            }
                        }
                        catch (NoSuchMethodException e) {
                            throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
                        }
                        catch (IllegalAccessException e) {
                            throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
                        }
                        catch (InvocationTargetException e) {
                            throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
                        }
                    }
                });
            }
        } else {
            throw new BusinessException("\u6570\u636e\u5df2\u88ab\u60a8\u7684\u540c\u4e8b\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u83b7\u53d6\u6700\u65b0\u6570\u636e\u518d\u4fdd\u5b58\uff01");
        }
        if (isSuccess && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("insertOrUpdateOne");
            esEntity.setContent(JSON.toJSONString(entity));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean saveOrUpdateNoES(T entity) {
        return this.saveOrUpdate(entity, false);
    }

    @Override
    public boolean saveOrUpdateBatch(List<T> entityList, int batchSize, boolean syncEs) {
        boolean isSuccess = super.saveOrUpdateBatch(entityList, batchSize);
        if (isSuccess && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(entityList.get(0).getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("insertOrUpdateBatch");
            esEntity.setContent(JSON.toJSONString(entityList));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public T selectById(Serializable id) {
        return this.selectById(id, null);
    }

    @Override
    public T selectById(Serializable id, Map<String, LinkedHashMap<String, String>> subOrderMap) {
        Field[] fields;
        Object entity = ((BaseCrudMapper)this.baseMapper).selectById(id);
        if (entity == null) {
            return null;
        }
        if (this.extFieldsMode.booleanValue()) {
            try {
                Map mainCustomBusinessDataMap;
                ArrayList<Long> businessIdList = new ArrayList<Long>();
                businessIdList.add((Long)id);
                CommonResponse<Map<Long, CustomBusinessDataVO>> mainCustomBusinessDataResponse = this.customBusinessDataService.queryCustomBusinessData(businessIdList);
                if (mainCustomBusinessDataResponse.isSuccess() && !(mainCustomBusinessDataMap = (Map)mainCustomBusinessDataResponse.getData()).isEmpty()) {
                    CustomBusinessDataVO customBusinessDataVo = (CustomBusinessDataVO)mainCustomBusinessDataMap.get(id);
                    Class<?> mainClass = entity.getClass();
                    Method customFieldMethod = mainClass.getSuperclass().getDeclaredMethod("setCustomField", Map.class);
                    JSONObject customField = JSONObject.parseObject((String)customBusinessDataVo.getBusinessData());
                    customFieldMethod.invoke(entity, customField);
                }
            }
            catch (Exception e) {
                this.logger.warn("\u6269\u5c55\u6570\u636e\u5b58\u50a8\u6216\u8bfb\u53d6\u5931\u8d25\uff0c \u5982\u679c\u6709\u4f7f\u7528\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u5728\u60a8\u7684\u5fae\u670d\u52a1\u6570\u636e\u5e93\u4e2d\u5efa\u7acbejc_custom_businessdata\u8868");
            }
        }
        Class<?> mainClass = entity.getClass();
        for (Field field : fields = mainClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SubEntity.class)) continue;
            SubEntity subEntity = field.getAnnotation(SubEntity.class);
            String serviceName = subEntity.serviceName();
            String fieldName = field.getName();
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6e\u5b50\u8868\u5b9e\u73b0\u7c7b\u670d\u52a1\u540d\uff01");
            }
            BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
            if (subService == null) {
                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u5b50\u8868\u6ca1\u6709\u5b9e\u73b0\u7c7b\uff01");
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put(subEntity.pidName(), new Parameter("eq", (Object)id));
            if (subOrderMap != null) {
                if (subOrderMap.get(fieldName) != null) {
                    queryParam.setOrderMap(subOrderMap.get(fieldName));
                } else {
                    queryParam.getOrderMap().put("id", "asc");
                }
            } else {
                queryParam.getOrderMap().put("id", "asc");
            }
            List<T> subList = subService.queryList(queryParam, false);
            if (this.extFieldsMode.booleanValue()) {
                try {
                    if (subList != null && subList.size() > 0) {
                        ArrayList<Long> subBusinessIdList = new ArrayList<Long>();
                        for (T sub : subList) {
                            Class<?> subClass = sub.getClass();
                            Method subPkIdMethod = subClass.getSuperclass().getDeclaredMethod("getId", null);
                            Long businessId = (Long)subPkIdMethod.invoke(sub, (Object[])null);
                            subBusinessIdList.add(businessId);
                        }
                        CommonResponse<Map<Long, CustomBusinessDataVO>> subCustomBusinessDataResponse = this.customBusinessDataService.queryCustomBusinessData(subBusinessIdList);
                        if (subCustomBusinessDataResponse.isSuccess()) {
                            Map subCustomBusinessDataMap = (Map)subCustomBusinessDataResponse.getData();
                            for (T sub : subList) {
                                Class<?> subClass = sub.getClass();
                                Method subPkIdMethod = subClass.getSuperclass().getDeclaredMethod("getId", null);
                                Long businessId = (Long)subPkIdMethod.invoke(sub, (Object[])null);
                                CustomBusinessDataVO subCustomBusinessDataVo = (CustomBusinessDataVO)subCustomBusinessDataMap.get(businessId);
                                if (subCustomBusinessDataVo == null) continue;
                                Method subCustomFieldMethod = subClass.getSuperclass().getDeclaredMethod("setCustomField", Map.class);
                                JSONObject subCustomField = JSONObject.parseObject((String)subCustomBusinessDataVo.getBusinessData());
                                subCustomFieldMethod.invoke(sub, subCustomField);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("\u6269\u5c55\u6570\u636e\u5b58\u50a8\u6216\u8bfb\u53d6\u5931\u8d25\uff0c \u5982\u679c\u6709\u4f7f\u7528\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u5728\u60a8\u7684\u5fae\u670d\u52a1\u6570\u636e\u5e93\u4e2d\u5efa\u7acbejc_custom_businessdata\u8868");
                }
            }
            try {
                Class[] cArg = new Class[]{field.getType()};
                Method setSubList = mainClass.getDeclaredMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), cArg);
                setSubList.invoke(entity, subList);
            }
            catch (NoSuchMethodException e) {
                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u672a\u5b9a\u4e49set\u65b9\u6cd5\uff01");
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u9700\u8981\u662fpublic\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff01");
            }
        }
        return (T)entity;
    }

    @Override
    public boolean removeById(Serializable id, boolean syncEs) {
        boolean isSuccess = false;
        T entity = this.selectById(id);
        if (entity != null) {
            isSuccess = super.removeById(id);
            if (isSuccess) {
                Field[] fields;
                Class<?> mainClass = entity.getClass();
                try {
                    if (this.extFieldsMode.booleanValue()) {
                        ArrayList<Long> mainBusinessIdList = new ArrayList<Long>();
                        mainBusinessIdList.add((Long)id);
                        this.customBusinessDataService.deleteCustomBusinessData(mainBusinessIdList);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("\u6269\u5c55\u6570\u636e\u5b58\u50a8\u6216\u8bfb\u53d6\u5931\u8d25\uff0c \u5982\u679c\u6709\u4f7f\u7528\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u5728\u60a8\u7684\u5fae\u670d\u52a1\u6570\u636e\u5e93\u4e2d\u5efa\u7acbejc_custom_businessdata\u8868");
                }
                for (Field field : fields = mainClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(SubEntity.class)) continue;
                    SubEntity subEntity = field.getAnnotation(SubEntity.class);
                    String serviceName = subEntity.serviceName();
                    String fieldName = field.getName();
                    if (StringUtils.isBlank((CharSequence)serviceName)) {
                        throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6e\u5b50\u8868\u5b9e\u73b0\u7c7b\u670d\u52a1\u540d\uff01");
                    }
                    BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                    if (subService == null) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u5b50\u8868\u6ca1\u6709\u5b9e\u73b0\u7c7b\uff01");
                    }
                    try {
                        Method getSubList = mainClass.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), null);
                        List subs = (List)getSubList.invoke(entity, (Object[])null);
                        if (ListUtil.isEmpty((List)subs)) continue;
                        subService.removeByIds(subs.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                        try {
                            if (!this.extFieldsMode.booleanValue()) continue;
                            this.customBusinessDataService.deleteCustomBusinessData(subs.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                        }
                        catch (Exception e) {
                            this.logger.warn("\u6269\u5c55\u6570\u636e\u5b58\u50a8\u6216\u8bfb\u53d6\u5931\u8d25\uff0c \u5982\u679c\u6709\u4f7f\u7528\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u5728\u60a8\u7684\u5fae\u670d\u52a1\u6570\u636e\u5e93\u4e2d\u5efa\u7acbejc_custom_businessdata\u8868");
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u672a\u5b9a\u4e49set\u65b9\u6cd5\uff01");
                    }
                    catch (IllegalAccessException e) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u9700\u8981\u662fpublic\u5c5e\u6027\uff01");
                    }
                    catch (InvocationTargetException e) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff01");
                    }
                }
            }
            if (isSuccess && syncEs) {
                TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
                String indexName = tableInfo.getTableName();
                EsEntity esEntity = new EsEntity();
                esEntity.setIndexName(indexName);
                esEntity.setType("deleteById");
                esEntity.setContent(id.toString());
                MqMessage mqMessage = new MqMessage();
                mqMessage.setBody((Object)esEntity);
                this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
            }
        }
        return isSuccess;
    }

    @Override
    public boolean removeByMap(Map<String, Object> columnMap, boolean syncEs) {
        boolean isSuccess = false;
        Collection list = super.listByMap(columnMap);
        if (list != null && list.size() > 0 && (isSuccess = super.removeByMap(columnMap)) && syncEs) {
            Object tableBean = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object bean : list) {
                tableBean = bean;
                BaseEntity baseEntity = (BaseEntity)bean;
                ids.add(baseEntity.getId());
            }
            TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("deleteBatch");
            esEntity.setContent(JSON.toJSONString(ids));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean remove(Wrapper<T> wrapper, boolean syncEs) {
        boolean isSuccess = false;
        List list = super.list(wrapper);
        if (list != null && list.size() > 0 && (isSuccess = super.remove(wrapper)) && syncEs) {
            Object tableBean = null;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object bean : list) {
                tableBean = bean;
                BaseEntity baseEntity = (BaseEntity)bean;
                ids.add(baseEntity.getId());
            }
            TableInfo tableInfo = TableInfoTool.initTableInfo(tableBean.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("deleteBatch");
            esEntity.setContent(JSON.toJSONString(ids));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList, boolean syncEs) {
        boolean isSuccess = false;
        for (Serializable serializable : idList) {
            isSuccess = this.removeById(serializable, syncEs);
            if (isSuccess) continue;
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
        return isSuccess;
    }

    @Override
    public boolean update(T entity, Wrapper<T> updateWrapper, boolean syncEs) {
        boolean isSuccess = super.update(entity, updateWrapper);
        if (isSuccess && syncEs) {
            TableInfo tableInfo = TableInfoTool.initTableInfo(entity.getClass());
            String indexName = tableInfo.getTableName();
            EsEntity esEntity = new EsEntity();
            esEntity.setIndexName(indexName);
            esEntity.setType("insertOrUpdateOne");
            esEntity.setContent(JSON.toJSONString(entity));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)esEntity);
            this.rabbitTemplate.convertAndSend(this.applicationName, (Object)mqMessage);
        }
        return isSuccess;
    }

    @Override
    public List<T> queryList(QueryParam queryParam, boolean isEs) {
        List list;
        if (isEs) {
            list = this.baseEsQueryDao.selectList(queryParam);
        } else {
            List complexParams;
            QueryWrapper queryWrapper = new QueryWrapper();
            Map params = queryParam.getParams();
            if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText()) && !ListUtil.isEmpty((List)queryParam.getFuzzyFields())) {
                String searchText = queryParam.getSearchText();
                List fuzzyFields = queryParam.getFuzzyFields();
                if (queryParam.getFuzzyFields().size() == 1) {
                    queryWrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)queryParam.getFuzzyFields().get(0))), (Object)searchText);
                } else {
                    queryWrapper.and(wrapper -> {
                        for (int i = 0; i < fuzzyFields.size(); ++i) {
                            wrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)queryParam.getFuzzyFields().get(i))), (Object)searchText);
                            if (i == fuzzyFields.size() - 1) continue;
                            wrapper.or();
                        }
                        return wrapper;
                    });
                }
            }
            BaseServiceImpl.setParam(queryWrapper, params);
            if (StringUtils.isNotEmpty((CharSequence)queryParam.getSearchObject())) {
                BaseServiceImpl.setSearchObjectParam(queryWrapper, JSONObject.parseObject((String)queryParam.getSearchObject()));
            }
            if (!ListUtil.isEmpty((List)(complexParams = queryParam.getComplexParams()))) {
                complexParams.forEach(c -> {
                    if ("and".equals(c.getLogic())) {
                        queryWrapper.and(w -> BaseServiceImpl.setWrapper(w, c));
                    } else {
                        queryWrapper.or(w -> BaseServiceImpl.setWrapper(w, c));
                    }
                });
            }
            LinkedHashMap orderMap = queryParam.getOrderMap();
            for (String key : orderMap.keySet()) {
                String value = (String)orderMap.get(key);
                if ("asc".equals(value.toLowerCase())) {
                    queryWrapper.orderByAsc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
                    continue;
                }
                if (!"desc".equals(value.toLowerCase())) continue;
                queryWrapper.orderByDesc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
            }
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    private static <T> QueryWrapper<T> setWrapper(QueryWrapper<T> w, ComplexParam c) {
        List complexParams;
        if (c.getParams() != null && !c.getParams().isEmpty()) {
            BaseServiceImpl.setParam(w, c.getParams());
        }
        if (!ListUtil.isEmpty((List)(complexParams = c.getComplexParams()))) {
            complexParams.forEach(complex -> {
                if ("and".equals(complex.getLogic())) {
                    w.and(wrapper -> BaseServiceImpl.setWrapper(wrapper, complex));
                } else {
                    w.or(wrapper -> BaseServiceImpl.setWrapper(wrapper, complex));
                }
            });
        }
        return w;
    }

    @Override
    public IPage<T> queryPage(QueryParam queryParam, boolean isEs) {
        IPage page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        if (queryParam.getPageSize() == -1) {
            List<T> records = this.queryList(queryParam, isEs);
            page.setRecords(records);
            return page;
        }
        if (isEs) {
            page = this.baseEsQueryDao.selectPage(page, queryParam);
        } else {
            page = this.page(page, (Wrapper)BaseServiceImpl.changeToQueryWrapper(queryParam));
            try {
                List records;
                if (this.extFieldsMode.booleanValue() && (records = page.getRecords()) != null && records.size() > 0) {
                    ArrayList<Long> businessIdList = new ArrayList<Long>();
                    for (Object record : records) {
                        Class<?> clazz = record.getClass();
                        Method mainPkIdMethod = clazz.getSuperclass().getDeclaredMethod("getId", null);
                        Long businessId = (Long)mainPkIdMethod.invoke(record, (Object[])null);
                        businessIdList.add(businessId);
                    }
                    CommonResponse<Map<Long, CustomBusinessDataVO>> customBusinessDataResponse = this.customBusinessDataService.queryCustomBusinessData(businessIdList);
                    if (customBusinessDataResponse.isSuccess()) {
                        Map customBusinessDataMap = (Map)customBusinessDataResponse.getData();
                        for (Object record : records) {
                            Class<?> clazz = record.getClass();
                            Method mainPkIdMethod = clazz.getSuperclass().getDeclaredMethod("getId", null);
                            Long businessId = (Long)mainPkIdMethod.invoke(record, (Object[])null);
                            CustomBusinessDataVO subCustomBusinessDataVo = (CustomBusinessDataVO)customBusinessDataMap.get(businessId);
                            if (subCustomBusinessDataVo == null) continue;
                            Method subCustomFieldMethod = clazz.getSuperclass().getDeclaredMethod("setCustomField", Map.class);
                            JSONObject subCustomField = JSONObject.parseObject((String)subCustomBusinessDataVo.getBusinessData());
                            subCustomFieldMethod.invoke(record, subCustomField);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("\u6269\u5c55\u6570\u636e\u5b58\u50a8\u6216\u8bfb\u53d6\u5931\u8d25\uff0c \u5982\u679c\u6709\u4f7f\u7528\u6269\u5c55\u5b57\u6bb5\uff0c\u8bf7\u5728\u60a8\u7684\u5fae\u670d\u52a1\u6570\u636e\u5e93\u4e2d\u5efa\u7acbejc_custom_businessdata\u8868");
            }
        }
        return page;
    }

    @Override
    public List<T> queryList(QueryParam queryParam) {
        return this.queryList(queryParam, false);
    }

    @Override
    public IPage<T> queryPage(QueryParam queryParam) {
        return this.queryPage(queryParam, false);
    }

    private static <T> void setParam(QueryWrapper<T> queryWrapper, Map<String, Parameter> params) {
        for (Map.Entry<String, Parameter> entry : params.entrySet()) {
            Parameter param = entry.getValue();
            String type = param.getType();
            if (!BaseServiceImpl.isValidKey(entry.getKey().toLowerCase())) {
                throw new BusinessException("\u5b58\u5728\u975e\u6cd5\u67e5\u8be2\u53c2\u6570key\uff1a" + entry.getKey());
            }
            if (param.getValue() != null && !BaseServiceImpl.isValidKey(param.getValue().toString().toLowerCase())) {
                throw new BusinessException("\u5b58\u5728\u975e\u6cd5\u67e5\u8be2\u53c2\u6570\u503c\uff1a" + entry.getKey() + ":" + param.getValue());
            }
            switch (type) {
                case "eq": {
                    if (null == param.getValue()) {
                        queryWrapper.isNull((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()));
                        break;
                    }
                    queryWrapper.eq((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "ne": {
                    if (null == param.getValue()) {
                        queryWrapper.isNotNull((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()));
                        break;
                    }
                    queryWrapper.ne((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "in": {
                    if (param.getValue() instanceof List) {
                        queryWrapper.in((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), (Collection)((List)param.getValue()));
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    queryWrapper.in((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), paramArr);
                    break;
                }
                case "not_in": {
                    if (param.getValue() instanceof List) {
                        queryWrapper.notIn((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), (Collection)((List)param.getValue()));
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    queryWrapper.notIn((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), paramArr);
                    break;
                }
                case "like": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "not_like": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.notLike((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "like_left": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.likeLeft((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "like_right": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.likeRight((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "between": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    queryWrapper.between((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), paramArr[0], paramArr[1]);
                    break;
                }
                case "lt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.lt((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "le": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.le((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "gt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.gt((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                    break;
                }
                case "ge": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    queryWrapper.ge((Object)CamelAndUnderLineConverter.humpToLine((String)entry.getKey()), param.getValue());
                }
            }
        }
    }

    private static <T> void setSearchObjectParam(QueryWrapper<T> queryWrapper, JSONObject params) {
        for (String key : params.keySet()) {
            queryWrapper.eq((Object)CamelAndUnderLineConverter.humpToLine((String)key), params.get((Object)key));
        }
    }

    public static <T> QueryWrapper<T> changeToQueryWrapper(QueryParam queryParam) {
        List complexParams;
        QueryWrapper queryWrapper = new QueryWrapper();
        Map params = queryParam.getParams();
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText()) && !ListUtil.isEmpty((List)queryParam.getFuzzyFields())) {
            String searchText = queryParam.getSearchText();
            List fuzzyFields = queryParam.getFuzzyFields();
            if (queryParam.getFuzzyFields().size() == 1) {
                queryWrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)queryParam.getFuzzyFields().get(0))), (Object)searchText);
            } else {
                queryWrapper.and(wrapper -> {
                    for (int i = 0; i < fuzzyFields.size(); ++i) {
                        wrapper.like((Object)CamelAndUnderLineConverter.humpToLine((String)((String)queryParam.getFuzzyFields().get(i))), (Object)searchText);
                        if (i == fuzzyFields.size() - 1) continue;
                        wrapper.or();
                    }
                    return wrapper;
                });
            }
        }
        BaseServiceImpl.setParam(queryWrapper, params);
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getSearchObject())) {
            BaseServiceImpl.setSearchObjectParam(queryWrapper, JSONObject.parseObject((String)queryParam.getSearchObject()));
        }
        if (!ListUtil.isEmpty((List)(complexParams = queryParam.getComplexParams()))) {
            complexParams.forEach(c -> {
                if ("and".equals(c.getLogic())) {
                    queryWrapper.and(w -> BaseServiceImpl.setWrapper(w, c));
                } else {
                    queryWrapper.or(w -> BaseServiceImpl.setWrapper(w, c));
                }
            });
        }
        LinkedHashMap orderMap = queryParam.getOrderMap();
        for (String key : orderMap.keySet()) {
            String value = (String)orderMap.get(key);
            if ("asc".equals(value.toLowerCase())) {
                queryWrapper.orderByAsc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
                continue;
            }
            if (!"desc".equals(value.toLowerCase())) continue;
            queryWrapper.orderByDesc((Object)CamelAndUnderLineConverter.humpToLine((String)key));
        }
        return queryWrapper;
    }

    private static boolean isValidKey(String key) {
        return !sqlPattern.matcher(key).find();
    }

    public static void main(String[] args) {
        System.out.println(BaseServiceImpl.isValidKey("delete * from -- "));
    }
}

