/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.skeleton.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class OpenApiHttpTools {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private static Map<String, String> systemInfo = new HashMap<String, String>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CommonResponse<String> getAccessToken(String systemId, String appId, String secret, String appHost, Map<String, String> headers) {
        try {
            String eachLinkHost = null;
            if (StringUtils.isEmpty((CharSequence)appId)) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", systemId);
                String result = ReferHttpClientUtils.get(this.baseHost + "ejc-idm-web/enterprise/queryDetail", params, ReferHttpClientUtils.getHeaders());
                if (!StringUtils.isNotEmpty((CharSequence)result)) return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
                JSONObject res = JSONObject.parseObject((String)result);
                if (res.getInteger("code") != 0) return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
                JSONObject data = res.getJSONObject("data");
                eachLinkHost = data.getString("dataHost");
                appId = data.getString("dataAppId");
                secret = data.getString("dataAppSecret");
                if (StringUtils.isEmpty((CharSequence)eachLinkHost) || StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)secret)) {
                    return CommonResponse.error((String)"\u67e5\u8be2\u4f01\u4e1a\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                systemInfo.put(systemId, eachLinkHost);
            } else {
                eachLinkHost = appHost;
            }
            if (this.redisTemplate.opsForValue().get((Object)("EachLink-Open-Api-Access-Token-" + appId)) != null) {
                headers.put("access_token", this.redisTemplate.opsForValue().get((Object)("EachLink-Open-Api-Access-Token-" + appId)).toString());
                return CommonResponse.success();
            } else {
                if (!eachLinkHost.endsWith("/")) {
                    eachLinkHost = eachLinkHost + "/";
                }
                String initContextUrl = eachLinkHost + "ejc-idm-web/auth/getAccessToken";
                String responseStr = null;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("appId", appId);
                params.put("secret", secret);
                responseStr = HttpTookit.get((String)initContextUrl, params, new HashMap());
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"0".equals(json.get((Object)"code").toString())) return CommonResponse.error((String)"eachLink\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                JSONObject data = json.getJSONObject("data");
                this.logger.info("------------  eachLink\u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42 data = " + data + "  ------------");
                if (!data.getBoolean("querysucflag").booleanValue()) return CommonResponse.error((String)"eachLink\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                String access_token = data.getString("access_token");
                headers.put("access_token", access_token);
                this.redisTemplate.opsForValue().set((Object)("EachLink-Open-Api-Access-Token-" + appId), (Object)access_token, 6000L, TimeUnit.SECONDS);
            }
            return CommonResponse.success();
        }
        catch (GeneralSecurityException e) {
            this.logger.info("eachLink GeneralSecurityException \u5f02\u5e38" + e.getMessage());
            return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
        catch (IOException e) {
            this.logger.info("eachLink IOException \u5f02\u5e38" + e.getMessage());
            return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
    }

    private String getHost(String systemId, String appHost) {
        if (StringUtils.isEmpty((CharSequence)appHost)) {
            return systemInfo.get(systemId);
        }
        return appHost;
    }

    public CommonResponse<String> postWithFile(String systemId, String appId, String secret, String appHost, String url, Map<String, String> params, Map<String, Map<String, InputStream>> files) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> acc = this.getAccessToken(systemId, appId, secret, appHost, headers);
        if (!acc.isSuccess()) {
            return acc;
        }
        String responseStr = null;
        String host = this.getHost(systemId, appHost);
        try {
            responseStr = HttpTookit.postFiles((String)(host + url), params, headers, files, (Integer)20000, (Integer)20000);
            this.logger.info("postWithFile\u8bf7\u6c42{} \u53c2\u6570{} \u8bf7\u6c42\u5934AccessToken {} \u54cd\u5e94 {}", new Object[]{host + url, params == null ? null : JSONObject.toJSONString(params), headers.get("access_token"), responseStr});
            return CommonResponse.success((String)"\u8bf7\u6c42\u6210\u529f!", (Object)responseStr);
        }
        catch (IOException | GeneralSecurityException e) {
            this.logger.info("postWithFile\u8bf7\u6c42{} \u53c2\u6570{} \u5f02\u5e38 {}", new Object[]{host + url, params == null ? null : JSONObject.toJSONString(params), e.getMessage()});
            return CommonResponse.error((String)"\u8bf7\u6c42\u5f02\u5e38");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("postWithFile\u8bf7\u6c42{} \u53c2\u6570{} \u5f02\u5e38 {}", new Object[]{host + url, params == null ? null : JSONObject.toJSONString(params), e.getMessage()});
            return CommonResponse.error((String)"\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public CommonResponse<String> postByJson(String systemId, String appId, String secret, String appHost, String url, String parameterStr) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> acc = this.getAccessToken(systemId, appId, secret, appHost, headers);
        if (!acc.isSuccess()) {
            return acc;
        }
        String responseStr = null;
        String host = this.getHost(systemId, appHost);
        try {
            responseStr = HttpTookit.postByJson((String)(host + url), (String)parameterStr, headers, (Integer)20000, (Integer)20000);
            this.logger.info("postByJson\u8bf7\u6c42{} \u53c2\u6570{} \u8bf7\u6c42\u5934AccessToken {} \u54cd\u5e94 {}", new Object[]{host + url, parameterStr, headers.get("access_token"), responseStr});
            return CommonResponse.success((String)"\u8bf7\u6c42\u6210\u529f!", (Object)responseStr);
        }
        catch (IOException | GeneralSecurityException e) {
            this.logger.info("postByJson\u8bf7\u6c42{} \u53c2\u6570{} \u5f02\u5e38 {}", new Object[]{host + url, parameterStr, e.getMessage()});
            return CommonResponse.error((String)"\u8bf7\u6c42\u5f02\u5e38");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("postByJson\u8bf7\u6c42{} \u53c2\u6570{} \u5f02\u5e38 {}", new Object[]{host + url, parameterStr, e.getMessage()});
            return CommonResponse.error((String)"\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public CommonResponse<String> getByJson(String systemId, String appId, String secret, String appHost, String url, Map<String, ?> params) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> acc = this.getAccessToken(systemId, appId, secret, appHost, headers);
        if (!acc.isSuccess()) {
            return acc;
        }
        String responseStr = null;
        String host = this.getHost(systemId, appHost);
        try {
            responseStr = HttpTookit.get((String)(host + url), params, headers, (int)20000, (int)20000);
            this.logger.info("getByJson\u8bf7\u6c42{} \u8bf7\u6c42\u5934AccessToken {} \u54cd\u5e94 {}", new Object[]{host + url, headers.get("access_token"), responseStr});
            return CommonResponse.success((String)"\u8bf7\u6c42\u6210\u529f!", (Object)responseStr);
        }
        catch (IOException | GeneralSecurityException e) {
            this.logger.info("getByJson\u8bf7\u6c42{} \u53c2\u6570{} \u5f02\u5e38 {}", new Object[]{host + url, JSONObject.toJSONString(params), e.getMessage()});
            return CommonResponse.error((String)"\u8bf7\u6c42\u5f02\u5e38");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("getByJson\u8bf7\u6c42{} \u53c2\u6570{} \u5f02\u5e38 {}", new Object[]{host + url, JSONObject.toJSONString(params), e.getMessage()});
            return CommonResponse.error((String)"\u8bf7\u6c42\u5f02\u5e38");
        }
    }
}

