package com.ejianc.framework.skeleton.refer.serialize;

import java.io.IOException;
import java.util.Iterator;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;

/**
 * 将json{id:xx,code:xx,name:xx}转换成ID 参照多选id-code-name转id
 *
 */
public class ReferDeserializer extends JsonDeserializer<Object> {
	@Override
	public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
		JsonNode node = jp.getCodec().readTree(jp);
		if (node != null) {
			if (node instanceof ArrayNode) {
				ArrayNode nodes = (ArrayNode) node;
				Iterator<JsonNode> it = nodes.iterator();
				StringBuffer sb = new StringBuffer();
				while (it.hasNext()) {
					JsonNode item = it.next();
					String id = item.get("id").asText();
					sb.append(id).append(",");
				}
				if (sb.toString().endsWith(",")) {
					return sb.deleteCharAt(sb.lastIndexOf(",")).toString();
				} else {
					return sb.toString();
				}
			}
			if (node instanceof TextNode) {
				return Long.parseLong(node.asText());
			}
			else if (node.get("id") != null) {
				String id = node.get("id").asText();
				return Long.parseLong(id);
			}
		}
		return Long.parseLong(jp.getText());
	}

}
