package com.ejianc.framework.skeleton.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Service
public class OpenApiHttpTools {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private static Map<String,String> systemInfo = new HashMap<>();

    /**
     * 获取 益企工程云 平台 access_token服务
     * @param headers 请求头
     * @param force 是否强制获取access_token
     */
    private CommonResponse<String> getAccessToken(String systemId,String appId,String secret,String appHost,Map<String, String> headers,Boolean force) {

        try {
            String eachLinkHost = null;
            if(StringUtils.isEmpty(appId)){//有一个为空则取平台数据
                Map<String, String> params = new HashMap<>();
                params.put("id",systemId);
                String result = ReferHttpClientUtils.get(baseHost+"ejc-idm-web/enterprise/queryDetail",params,ReferHttpClientUtils.getHeaders());
                if(StringUtils.isNotEmpty(result)){
                    JSONObject res = JSONObject.parseObject(result);
                    if(res.getInteger("code") == 0){
                        JSONObject data = res.getJSONObject("data");
                        eachLinkHost = data.getString("dataHost");
                        appId = data.getString("dataAppId");
                        secret = data.getString("dataAppSecret");
                        if(StringUtils.isEmpty(eachLinkHost) || StringUtils.isEmpty(appId) || StringUtils.isEmpty(secret)){
                            return CommonResponse.error("查询企业配置信息为空！");
                        }
                        systemInfo.put(systemId,eachLinkHost);
                    }else {
                        return CommonResponse.error("查询企业配置信息失败！");
                    }
                }else {
                    return CommonResponse.error("查询企业配置信息失败！");
                }
            }else {
                eachLinkHost = appHost;
            }
            //获取redis中的 Access-Token，以EachLink-Open-Api-Access-Token-appId 为key 若不存在，则重新请求并放入redis中
            if(!force  && redisTemplate.opsForValue().get("EachLink-Open-Api-Access-Token-"+appId) != null){
                //若存在，直接放到header中
                headers.put("access_token", redisTemplate.opsForValue().get("EachLink-Open-Api-Access-Token-"+appId).toString());
            }else{
                if(!eachLinkHost.endsWith("/")){
                    eachLinkHost+="/";
                }
                String initContextUrl = eachLinkHost + "ejc-idm-web/auth/getAccessToken";
                String responseStr = null;
                Map<String,String> params = new HashMap<>();
                params.put("appId",appId);
                params.put("secret",secret);
                responseStr = HttpTookit.get(initContextUrl, params,new HashMap<>());
                JSONObject json = JSONObject.parseObject(responseStr);
                if("0".equals(json.get("code").toString())){
                    JSONObject data = json.getJSONObject("data");
                    logger.info("------------  eachLink获取access_token服务，请求 data = " + data + "  ------------");
                    if(data.getBoolean("querysucflag")){
                        String access_token = data.getString("access_token");
                        headers.put("access_token", access_token);
                        //将获取到的 access_token 放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于60分钟）
                        redisTemplate.opsForValue().set("EachLink-Open-Api-Access-Token-"+appId, access_token,60*50, TimeUnit.SECONDS);
                    }else {
                        return CommonResponse.error("eachLink获取供方access_token异常");
                    }
                }else{
                    //请求失败，输出错误信息
                    return CommonResponse.error("eachLink获取供方access_token异常");
                }
            }

        } catch (GeneralSecurityException e) {
            logger.info("eachLink GeneralSecurityException 异常"+e.getMessage());
            return CommonResponse.error("获取供方access_token异常");
        } catch (IOException e) {
            logger.info("eachLink IOException 异常"+e.getMessage());
            return CommonResponse.error("获取供方access_token异常");
        }
        return CommonResponse.success();
    }

    private String getHost(String systemId,String appHost){
        if(StringUtils.isEmpty(appHost)){
            return systemInfo.get(systemId);
        }
        return appHost;
    }

    /**
     * POST 方式 推送数据和文件
     * @param url           请求地址
     * @param parameterStr  json格式字符串
     */
    public CommonResponse<String> postWithFile(String systemId,String appId,String secret,String appHost,String url,Map<String, String> params, Map<String, Map<String, InputStream>> files){
        Map<String, String> headers = new HashMap();
        // 获取token
        CommonResponse<String> acc = getAccessToken(systemId,appId,secret,appHost,headers,false);
        if(!acc.isSuccess()){
            return acc;
        }
        String responseStr = null;
        String host =  getHost(systemId,appHost);
        try {
            responseStr = HttpTookit.postFiles(host+ url, params,headers,files,20000,20000);
            if("access_token已过期！".equals(responseStr) || "无权限访问该服务，请先联系管理员进行授权！".equals(responseStr) ){
                getAccessToken(systemId,appId,secret,appHost,headers,true);
                logger.info("重新获取AccessToken---- {} ", headers.get("access_token"));
                responseStr = HttpTookit.postFiles(host+ url, params,headers,files,20000,20000);
            }
            logger.info("postWithFile请求{} 参数{} 请求头AccessToken {} 响应 {}",host+ url,params==null?null:JSONObject.toJSONString(params),headers.get("access_token"),responseStr);
            return CommonResponse.success("请求成功!",responseStr);
        } catch (GeneralSecurityException | IOException e) {
            logger.info("postWithFile请求{} 参数{} 异常 {}",host+ url,params==null?null:JSONObject.toJSONString(params),e.getMessage());
            return CommonResponse.error("请求异常");
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("postWithFile请求{} 参数{} 异常 {}",host+ url,params==null?null:JSONObject.toJSONString(params),e.getMessage());
            return CommonResponse.error("请求异常");
        }

    }



    /**
     * POST 方式 获取 益企工程云 平台 服务数据
     * @param url           请求地址
     * @param parameterStr  json格式字符串
     */
    public CommonResponse<String> postByJson(String systemId,String appId,String secret,String appHost,String url, String parameterStr){
        Map<String, String> headers = new HashMap();
        // 获取token
        CommonResponse<String> acc = getAccessToken(systemId,appId,secret,appHost,headers,false);
        if(!acc.isSuccess()){
            return acc;
        }
        String responseStr = null;
        String host =  getHost(systemId,appHost);
        try {
            responseStr = HttpTookit.postByJson(host+ url, parameterStr,headers,20000,20000);
            if("access_token已过期！".equals(responseStr) || "无权限访问该服务，请先联系管理员进行授权！".equals(responseStr) ){
                getAccessToken(systemId,appId,secret,appHost,headers,true);
                logger.info("重新获取AccessToken---- {} ", headers.get("access_token"));
                responseStr = HttpTookit.postByJson(host+ url, parameterStr,headers,20000,20000);
            }
            logger.info("postByJson请求{} 参数{} 请求头AccessToken {} 响应 {}",host+ url,parameterStr,headers.get("access_token"),responseStr);
            return CommonResponse.success("请求成功!",responseStr);
        } catch (GeneralSecurityException | IOException e) {
            logger.info("postByJson请求{} 参数{} 异常 {}",host+ url,parameterStr,e.getMessage());
            return CommonResponse.error("请求异常");
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("postByJson请求{} 参数{} 异常 {}",host+ url,parameterStr,e.getMessage());
            return CommonResponse.error("请求异常");
        }

    }

    /**
     * POST 方式 获取 益企工程云 平台 服务数据
     * @param url           请求地址
     * @param params        参数map
     */
    public CommonResponse<String> getByJson(String systemId,String appId,String secret,String appHost,String url, Map<String, ?> params){
        Map<String, String> headers = new HashMap();
        // 获取token
        CommonResponse<String> acc = getAccessToken(systemId,appId,secret,appHost,headers,false);
        if(!acc.isSuccess()){
            return acc;
        }
        String responseStr = null;
        String host =  getHost(systemId,appHost);
        try {
            responseStr = HttpTookit.get(host+ url, params,headers,20000,20000);
            if("access_token已过期！".equals(responseStr) || "无权限访问该服务，请先联系管理员进行授权！".equals(responseStr) ){
                getAccessToken(systemId,appId,secret,appHost,headers,true);
                logger.info("重新获取AccessToken---- {} ", headers.get("access_token"));
                responseStr = HttpTookit.get(host+ url, params,headers,20000,20000);
            }
            logger.info("getByJson请求{} 请求头AccessToken {} 响应 {}",host+ url, headers.get("access_token"),responseStr);
            return CommonResponse.success("请求成功!",responseStr);
        } catch (GeneralSecurityException | IOException e) {
            logger.info("getByJson请求{} 参数{} 异常 {}",host+ url,JSONObject.toJSONString(params),e.getMessage());
            return CommonResponse.error("请求异常");
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("getByJson请求{} 参数{} 异常 {}",host+ url,JSONObject.toJSONString(params),e.getMessage());
            return CommonResponse.error("请求异常");
        }

    }
}
