package com.ejianc.framework.skeleton.dataPush.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.util.OpenApiHttpTools;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;


@Service
public class SystemDataPushServiceImpl implements ISystemDataPushService {

	@Value("${common.env.base-host}")
	private String baseHost;

	@Autowired
	private OpenApiHttpTools openApiHttpTools;

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	/**
	 *
	 * 数据流向  公有云平台====调用=>>>>私有化平台
	 *
	 * @param systemId        第三方系统id，来源公有云企业档案id或者数据中的systemId 必填
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头  注意，工程路径后面需要加上openapi，否则无法调通，必填
	 * @param method          RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param postData        post方式请求的数据  post方式必填
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataWithThirdSystem(String url,RequestMethod method,String postData,String systemId) {
		if(StringUtils.isEmpty(systemId)){
			return CommonResponse.error("systemId不能为空！");
		}

		if(RequestMethod.POST.name().equals(method.name())){
			return  openApiHttpTools.postByJson(systemId,null,null,null,url,postData);
		}

		return openApiHttpTools.getByJson(systemId,null,null,null,url,null);
	}

	/**
	 * 数据流向  公有云平台====调用=>>>>私有化平台 包含文件传输 POST方式
	 *
	 * @param url      接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,以/开头 注意，工程路径后面需要加上openapi，否则无法调通， 必填
	 * @param params   参数
	 * @param systemId 第三方系统id，来源公有云企业档案id或者数据中的systemId 必填
	 * @param files    文件列表
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataAndFilesWithThirdSystem(String url, Map<String, String> params, String systemId, Map<String, Map<String, InputStream>> files) {
		return openApiHttpTools.postWithFile(systemId,null,null,null,url,params,files);
	}

	/**
	 *
	 * 数据流向  私有化平台====调用=>>>>公有云平台
	 *
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头 注意，工程路径后面需要加上openapi，否则无法调通， 必填
	 * @param method          RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param postData        post方式请求的数据  post方式必填
	 * @param supplierId      数据中的供应商ID ，必填
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataWithEachLinkSystem(String url, RequestMethod method, String postData, String supplierId) {
		if(StringUtils.isEmpty(url) || StringUtils.isEmpty(supplierId) ){
			return CommonResponse.error("url、supplierId不能为空！");
		}
		CommonResponse<JSONObject> response = getAuthInfoBySupplierId(supplierId);
		if(!response.isSuccess()){
			return CommonResponse.error(response.getMsg());
		}
		JSONObject auth = response.getData();

		String appHost = auth.getString("appHost");
		String appId = auth.getString("appId");
		String appSecret = auth.getString("appSecret");

		if(RequestMethod.POST.name().equals(method.name())){
			return  openApiHttpTools.postByJson(null,appId,appSecret,appHost,url,postData);
		}

		return openApiHttpTools.getByJson(null,appId,appSecret,appHost,url,null);
	}

	public CommonResponse<JSONObject> getAuthInfoBySupplierId(String supplierId){
		JSONObject auth = new JSONObject();
		if(redisTemplate.opsForValue().get("EachLink-Open-Api-Info-"+supplierId) == null){
			Map<String, String> params = new HashMap<>();
			params.put("id",supplierId);
			try {
				String result = ReferHttpClientUtils.get(baseHost+"ejc-share-web/supplier/generateAccessToken",params,ReferHttpClientUtils.getHeaders());
				if(StringUtils.isNotEmpty(result)){
					JSONObject res = JSONObject.parseObject(result);
					if(res.getInteger("code") != 0){
						return CommonResponse.error("查询企业配置信息失败！");
					}
				}else {
					return CommonResponse.error("查询企业配置信息失败！");
				}
			} catch (GeneralSecurityException e) {
				e.printStackTrace();
				return CommonResponse.error("查询企业配置信息失败！");
			} catch (IOException e) {
				e.printStackTrace();
				return CommonResponse.error("查询企业配置信息失败！");
			}
		}
		String cacheData = redisTemplate.opsForValue().get("EachLink-Open-Api-Info-"+supplierId).toString();
		String appHost = cacheData.split("------")[0];
		String appId = cacheData.split("------")[1];
		String appSecret = cacheData.split("------")[2];
		auth.put("appHost",appHost);
		auth.put("appId",appId);
		auth.put("appSecret",appSecret);
		return CommonResponse.success(auth);
	}

	/**
	 * 数据流向  私有化平台====调用=>>>>公有云平台 包含文件传输 POST方式
	 *
	 * @param url        接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx，以/开头  注意，工程路径后面需要加上openapi，否则无法调通，必填
	 * @param params     参数
	 * @param supplierId 数据中的供应商ID ，必填
	 * @param files      文件列表
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataAndFilesWithEachLinkSystem(String url, Map<String, String> params, String supplierId, Map<String, Map<String, InputStream>> files) {
		CommonResponse<JSONObject> response = getAuthInfoBySupplierId(supplierId);
		if(!response.isSuccess()){
			return CommonResponse.error(response.getMsg());
		}
		JSONObject auth = response.getData();

		String appHost = auth.getString("appHost");
		String appId = auth.getString("appId");
		String appSecret = auth.getString("appSecret");

		return openApiHttpTools.postWithFile(null,appId,appSecret,appHost,url,params,files);
	}

	/**
	 *
	 * 通用接口
	 *
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头 注意，工程路径后面需要加上openapi，否则无法调通， 必填
	 * @param method          RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param postData        post方式请求的数据  post方式必填
	 * @param appId           私有化平台(益企联)注册的AppID ，必填
	 * @param appSecret       私有化平台(益企联)注册的secret ，必填
	 * @param appHost         私有化平台(益企联)注册的请求地址，实例：http://testpm.ynsbj.com 以/结尾，必填
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataWithUniversal(String url, RequestMethod method, String postData, String appId, String appSecret, String appHost) {
		if(StringUtils.isEmpty(appId) || StringUtils.isEmpty(appSecret) || StringUtils.isEmpty(appHost)){
			return CommonResponse.error("appId、appSecret、appHost不能为空！");
		}

		if(RequestMethod.POST.name().equals(method.name())){
			return  openApiHttpTools.postByJson(null,appId,appSecret,appHost,url,postData);
		}

		return openApiHttpTools.getByJson(null,appId,appSecret,appHost,url,null);
	}

	/**
	 * 通用接口 携带文件
	 *
	 * @param url       接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,注意，工程路径后面需要加上openapi，否则无法调通，必填
	 * @param params    参数
	 * @param files     文件列表
	 * @param appId     私有化平台(益企联)注册的AppID ，必填
	 * @param appSecret 私有化平台(益企联)注册的secret ，必填
	 * @param appHost   私有化平台(益企联)注册的请求地址，实例：http://testpm.ynsbj.com 以/结尾，必填
	 * @return
	 */
	@Override
	public CommonResponse<String> exchangeDataAndFilesWithUniversal(String url, Map<String, String> params, Map<String, Map<String, InputStream>> files, String appId, String appSecret, String appHost) {
		return openApiHttpTools.postWithFile(null,appId,appSecret,appHost,url,params,files);
	}

}
